<?php

namespace Modules\TrackingOrder\Models;

use Illuminate\Database\Eloquent\Model;

class OrderItem extends Model
{
    protected $table = 'order_item';
    protected $fillable = [
        'order_id',
        'product_id',
        'product_sku_id',
        'quantity',
        'price',
        'configurations',
        'image_url',
        'design_url',
        'canvas',
        'cost',
        'shipping_cost',
        'resource_id',
        'printing_code',
        'seller_id',
    ];

    public function order() {
        return $this->belongsTo('App\Models\Order');
    }
}
