system.controller("OrderHistoryController", OrderHistoryController);

function OrderHistoryController($scope, $http, $rootScope) {
    this.__proto__ = new BaseController($scope, $http, $rootScope);
    $scope.histories = [];
    $scope.isLoading = false;
    $scope.pageId = 0;
    $scope.hasNext = false;

    $scope.initialize = function () {
        $scope.pageId = 0;
        $scope.hasNext = false;
        $scope.histories = [];
        $scope.find();
    }

    $scope.find = function () {
        $scope.isLoading = true;
        let url = clickerDomain + '/service/tracking/getAllHistoryFromToken';
        url += '?_token=' + $scope.order.attributes.token;
        url += '&min_create_time=' + $scope.subDate($scope.order.created_at, 90),
        url += '&limit=20';
        url += '&page=' + $scope.pageId;
        url += '&skip_source=1'

        fetch(url)
            .then(function (response) {
                return response.json();
            })
            .then(function (response) {
                $scope.$apply(function () {
                    if (response.status == 'successful') {
                        if (response.data.length > 0) {
                            $scope.histories = $scope.histories.concat(response.data);
                            $scope.hasNext = true;
                        } else {
                            $scope.hasNext = false;
                        }
                    } else {
                        $scope.hasNext = false;
                    }
                    $scope.isLoading = false;
                })
            })
            .catch(function (error) {
                $scope.$apply(function () {
                    $scope.isLoading = false;
                    $scope.hasNext = false;
                })
            })
    }

    $scope.loadMore = function () {
        $scope.pageId++;
        $scope.find();
    }

    $scope.addZero = function (num) {
        return num > 9 ? num : '0' + num;
    }

    $scope.subDate = function (dateString, day) {
        var dateParts = dateString.match(/^(\d{4})-(\d{2})-(\d{2})(?:\s+(\d{2}):(\d{2}):.*)$/);
        var year = dateParts[1];
        var month = dateParts[2];
        var day = dateParts[3];
        var date = new Date(year, month - 1, day);
        date.setTime(date.getTime() - day * 86400000);

        return date.getFullYear() + '-' + $scope.addZero(date.getMonth() + 1) + '-' + $scope.addZero(date.getDate());
    }

    $scope.$watch('order', function () {
        if ($scope.order && $scope.order.attributes && $scope.order.attributes.token) {
            $scope.initialize();
        } else {
            $scope.histories = [];
        }
    })
}