system.controller('OrderTrackingController', OrderTrackingController);

function OrderTrackingController($scope, $http, $rootScope) {
    this.__proto__ = new PaginationController($scope, $http, $rootScope);

    $scope.orders = [];

    $scope.filter = {
        status: 'DELIVERING',
        search : '',
        minDate: "",
        maxDate: "",
    }

    $scope.statuses = [
        {code: 'DELIVERING'}
    ];

    $scope.printers = [];

    $scope.initialize = () => 
    {
        const currentDate = new Date();
        const dateNow = getFormatedDate(currentDate);

        currentDate.setDate(currentDate.getDate() - 14);
        const date14DaysAgo = getFormatedDate(currentDate);

        $scope.filter.minDate = date14DaysAgo;
        $scope.filter.maxDate = dateNow;

        $scope.getStatusOrder();
        $scope.getPrinting();
        $scope.find();
    }

    function getFormatedDate(date)
    {
        const day = ("0" + date.getDate()).slice(-2);
        const month = ("0" + (date.getMonth() + 1)).slice(-2);
        const year = date.getFullYear();

        return day + '/' + month + '/' + year;
    }

    $scope.getPrinting = function () {
        return new Promise (function (resolve) {
            var urlPrinting = $scope.buildUrl('/printing?page_size=-1&sorts=sorder');
            $http.get(urlPrinting).then(function (response) {
                $scope.printers = response.data.result;
                resolve();
            }, function (error) {
                console.log(error);
                resolve();
            });
        });
    }

    $scope.buildFilterUrl = (paramOnly = false) => {
        let filterData = {
            page_size: $scope.meta.page_size,
            page_id: $scope.meta.page_id,
        }
        if ($scope.filter.printer) {
            filterData.printer = $scope.filter.printer;
        }
        if ($scope.filter.search) {
            filterData.search = $scope.filter.search;
        }
        if ($scope.filter.status) {
            filterData.status = $scope.filter.status;
        }

        if ($scope.filter.delay_days > 0) {
            filterData.delay_days = $scope.filter.delay_days;
        }

        $scope.filter.minDate = $scope.filter.minDate ? $scope.filter.minDate : '';
        $scope.filter.maxDate = $scope.filter.maxDate ? $scope.filter.maxDate : '';

        if ($scope.filter.minDate || $scope.filter.maxDate) {
            let minDate = $scope.vietnameseTimeToSQLTime($scope.filter.minDate);
            let maxDate = $scope.vietnameseTimeToSQLTime($scope.filter.maxDate);
            if (minDate) {
                filterData.min_date = `${minDate} 00:00:00`;
            }
            if (maxDate) {
                filterData.max_date = `${maxDate} 23:59:59`;
            }
        }

        let url = `/tracking-order/delay-tracking/find?`;

        let params = [];
        for (let field of Object.keys(filterData)) {
            params.push(`${field}=${Array.isArray(filterData[field]) ? filterData[field].join(',') : filterData[field]}`)
        }

        url += params.join('&');

        if (paramOnly) {
            return params.join('&');
        }

        return url;
    }

    $scope.getStatusOrder = function () {
        return new Promise(function (resolve) {
            var url = $scope.buildUrl('/order/status-config');
            $http.get(url).then(function (response) {
                $scope.statuses = response.data.all_statuses;
                resolve();
            }, function (error) {
                console.log(error);
                resolve();
            });
        });
    }

    $scope.find = (reset = false) => {
        if (reset) {
            $scope.meta.page_id = 0;
        }
        $http.get($scope.buildFilterUrl())
            .then(res => {
                $scope.meta = res.data.meta;
                $scope.orders = res.data.result;
                $scope.buildTracking();
            })
    }

    $scope.buildTracking = () => {
        for (let order of $scope.orders) {
            order.timelinesByCode = {};
            let printers = {};
            for (let item of order.order_items) {
                printers[item.printing_code] = 1;
            }
            order.printers = Object.keys(printers);
            for (let timeline of order.timelines) {
                if (!order.timelinesByCode[timeline.code]) {
                    order.timelinesByCode[timeline.code] = [];
                }
                order.timelinesByCode[timeline.code].push(timeline);
            }
        }
    }

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.find();
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.find();
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.find();
        }
    };

    $scope.clear = function () {
        $scope.filter = {
            status: 'DELIVERING',
            search : '',
            minDate: "",
            maxDate: "",
        }

        $scope.find(true);
    }

    $scope.export = () => {
        const filterParams = $scope.buildFilterUrl(true);
        const url = `/tracking-order/delay-tracking/export?${filterParams}`;

        toastr.success('Export file sẽ được gửi tới email của bạn'); 
        $http.get(url).then(res => { console.log(res.data) });
    }

    $scope.initialize();
}