<style>
    .table-scroll {
        max-height: 400px;
        overflow-y: scroll;
    }
</style>

@section('script')
    <script>
        var clickerDomain = "{{ config('tracking-order::clicker.domain') }}";
    </script>
    <script src="{{ Module::asset('tracking-order/js/order-history-controller.js') }}?v={{ config('sa.version') }}"></script>
@append

<div class="row" ng-controller="OrderHistoryController">
    <div class="col-md-12 ng-scope">
        <div class="order-layout order-layout-left box">
            <div class="box-header">
                <h4>Lịch sử truy cập của khách hàng</h4>
            </div>
            <div class="box-body table-scroll">
                <table class="table table-responsive" >
                    <thead>
                        <tr>
                            <th></th>
                            <th>Thời gian</th>
                            <th>Ip</th>
                            <th>Url</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr ng-repeat="item in histories" ng-if="histories.length > 0">
                            <td>@{{ $index + 1 }}</td>
                            <td>@{{ summarizeDateTime(item.create_time, true) }}</td>
                            <td>@{{ item.ip }}</td>
                            <td>
                                <a href="@{{ item.url }}">@{{ item.url }}</a>
                            </td>
                        </tr>
                        <tr ng-if="!isLoading && hasNext">
                            <td class="text-center" colspan="4">
                                <button class="btn btn-default" ng-click="loadMore()"><i class="fa fa-plus"></i> Load more</button>
                            </td>
                        </tr>
                        <tr ng-if="histories.length == 0 && !isLoading">
                            <td colspan="4" class="text-center">Không có lịch sử truy cập</td>
                        </tr>
                        <tr ng-if="isLoading">
                            <td colspan="4" class="text-center">
                                <img class="loading" src="/images/loading.gif" alt="loading">
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>