@extends('system.layout.main', [
    'ngController' => 'OrderTrackingController'
])
@section('title')
    <title><?= __s("Order Not Update Tracking")?></title>
@endsection

@section('css')
    <style>
        .timeline-wraper {
            max-height: 200px;
            overflow-y: auto;
        }
    </style>
@endsection

@section('content')
    <div class="content">
        <div class="row">
            <div class="col-md-12" style="margin: 15px 0px">
                <div class="pull-left">
                    <h3 style="margin: 0">
                        Order Not Update Tracking
                    </h3>
                </div>
            </div>
            <div class="col-md-12" style="min-height: 500px">
                <div class="box no-border">
                    <div class="nav-tabs-custom">
                        <ul class="nav nav-tabs hide-xs" style="border-bottom: 0px;">
                        </ul>
                    </div>
                    <!-- /.box-header -->
                    
                    <div class="box-body">
                        <div>
                            @include('tracking-order::system.tracking.filter')
                        </div>
                        <div>
                            @include('tracking-order::system.tracking.list')
                        </div>
                        <div class="pull-right">
                            @include('system.pagination')
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script src="/system/js/controllers/pagination/pagination-controller.js?v=<?= Config::get("sa.version") ?>" charset="utf-8"></script>
    <script src="{{ Module::asset('tracking-order/js/order-tracking-controller.js') }}?v=<?= Config::get("sa.version") ?>" charset="utf-8"></script>
@endsection