<table class="table table-responsive">
    <thead>
        <tr>
            <th></th>
            <th>Code</th>
            <th>Printer</th>
            <th style="width: 250px">Delivering Status</th>
            <th>Detail</th>
            {{-- <th>Latest Update</th> --}}
        </tr>
    </thead>
    <tbody>
        <tr ng-repeat="item in orders">
            <td>@{{ $index + 1 }}</td>
            <td>
                <p>Code: @{{ item.code }}</p>
                <p>Status: @{{ item.status }}</p>
                <p>Created at: <span class="time pull-left">@{{ toVietnameseDate(item.created_at, true) }} @{{ summarizeTime(item.created_at) }}</span></p>
            </td>
            <td>
                <p ng-repeat="printer in item.printers">@{{ printer }}</p>
            </td>
            <td>@{{ item.timelines[0].content }}</td>
            <td>
                <table class="table table-responsive">
                    <thead>
                        <th style="width: 150px">Tracking Code</th>
                        <th>Timelines</th>
                    </thead>
                    <tbody>
                        <tr ng-repeat="(code, timelines) in item.timelinesByCode">
                            <td style="width: 150px">@{{ code }}</td>
                            <td>
                                <div class="timeline-wraper">
                                    <ul class="timeline">
                                        <li ng-repeat="timeline in timelines">
                                            <i class="@{{ $index == 0 ? 'fa fa-circle bg-aqua' : 'fa fa-circle-o' }}"></i>
                                            <div class="timeline-item">
                                                <span class="time pull-left">@{{ toVietnameseDate(timeline.time, true) }} @{{ summarizeTime(timeline.time) }}</span>
                                                <div class="timeline-header">@{{ timeline.content }}</div>
                                            </div>
                                        </li>
                                    </ul>
                                </div>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </td>
            {{-- <td>@{{ toVietnameseDate(item.timeline_time, true) }} @{{ summarizeTime(item.timeline_time) }}</td> --}}
        </tr>
    </tbody>
</table>