<script type="text/javascript">
    var referHost = '';
    var fullUrl = window.location.href;
    var host = "<?php echo $_SERVER['HTTP_HOST']; ?>";
    var clickerDomain = "<?= config('tracking-order::clicker.domain') ?>";
    if (!referHost && typeof document.referrer != 'undefined' && document.referrer) {;
        if (document.referrer && !document.referrer.includes(host)) {
            referHost = document.referrer;
        }
    }
</script>
<?php
\Session::forget('tr');
\Session::forget('js_refer_url');
?>

<script>
    document.addEventListener("DOMContentLoaded", function(event) {
        $(document).on("created-order", function (event, param) {
            var orderId = param;
            if (orderId) {
                let tokenUserQuery = localStorage.getItem('token_user_query');
                fetch("/tracking-order/update-tracking-source", {
                    method: 'POST',
                    headers: {
                        'Accept': 'application/json',
                        'Content-Type': 'application/json'
                    },
                    crossDomain: true,
                    body: JSON.stringify({
                        order_id: orderId,
                        token: tokenUserQuery
                    })
                }).then(function (data) {

                });
            }
        });
    });


function trackingLastClick(referHost, fullUrl, host ){
	fetch(clickerDomain + "/t/ts", {
        method: 'POST',
        headers: {
            'Accept': 'application/json',
            'Content-Type': 'application/json'
        },
		crossDomain: true,
		body: JSON.stringify({
			url: encodeURIComponent(fullUrl),
			referHost: referHost,
			host: host,
			_token: getToken()
		})
	}).then(function (response) {
		return response.json();
	}).then(function(data) {
		if(data.result){
			setCookie("visit_source",data.result);

		}
	}).catch((err) => console.warn('trackingLastClick exception'));

}

function getToken() {
	let token;
	try {
		token = localStorage.getItem('token_user_query');
		if (!token) {
			token = getCookie('token_user_query');
			if (!token) {
				token = makeToken(30);
			}
			localStorage.setItem('token_user_query', token);
			setCookie('token_user_query', token);
		}
	} catch (e) {
		token = makeToken(30);
	}
	return token;
}


function makeToken(length) {
	var result           = '';
	var characters       = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
	var charactersLength = characters.length;
	for ( var i = 0; i < length; i++ ) {
		result += characters.charAt(Math.floor(Math.random() * charactersLength));
	}
	result += Date.now();
	return result;
}

function getIdentity() {
	var tokenIdentity = localStorage.getItem('user_identity');
	if (!tokenIdentity) {
		tokenIdentity = makeIdentity(15);
		localStorage.setItem('user_identity', tokenIdentity);
	}
	return tokenIdentity;
}

function makeIdentity(length) {
	var result = localStorage.getItem('token_user_query');
	if (!result) {
		result = '';
		var characters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789';
		var charactersLength = characters.length;
		for (var i = 0; i < length; i++) {
			result += characters.charAt(Math.floor(Math.random() * charactersLength));
		}
		result += Date.now();
	}
	return result;
}

function sessionIdentity() {
	var url = '/set-identity?identity=' +  getIdentity();

	fetch(url, function(result) {
	});
}


function setCookie(name, value, days) {
	if (days) {
		var date = new Date();
		date.setTime(date.getTime() + (days * 24 * 60 * 60 * 1000));
		var expires = "; expires=" + date.toGMTString();
	} else {
		var expires = "";
	}
	document.cookie = name + "=" + value + expires + "; path=/";
}

function getCookie(name) {
	var nameEQ = name + "=";
	var ca = document.cookie.split(';');
	for (var i = 0; i < ca.length; i++) {
		var c = ca[i];
		while (c.charAt(0) == ' ') {
			c = c.substring(1, c.length);
		}
		if (c.indexOf(nameEQ) == 0) {
			return c.substring(nameEQ.length, c.length);
		}
	}
	return null;
}

function ready(callback){
    // in case the document is already rendered
    if (document.readyState!='loading') callback();
    // modern browsers
    else if (document.addEventListener) document.addEventListener('DOMContentLoaded', callback);
    // IE <= 8
    else document.attachEvent('onreadystatechange', function(){
        if (document.readyState=='complete') callback();
    });
}

ready(function () {
	if(typeof referHost == 'undefined'){
		referHost = '';
	}
	if(typeof fullUrl == 'undefined'){
		fullUrl = '';
	}
	if(typeof host == 'undefined'){
		host = '';
	}
	trackingLastClick(referHost, fullUrl, host);
	getIdentity();

});
</script>
