<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */
Route::group(['prefix' => 'tracking-order', 'middleware' => 'example'], function () {
    Route::get('/', [
        'as' => 'tracking-order::home',
        'uses' => 'HomeController@index',
    ]);

    Route::any('/set-identity', [
        'as' => 'tracking-order::set-identity',
        'uses' => 'HomeController@setIdentity'
    ]);
    Route::any('/update-tracking-source', [
        'as' => 'tracking-order::updateTrackingSource',
        'uses' => 'HomeController@updateTrackingSource',
    ]);
    Route::any('/build-tracking-source', [
        'as' => 'tracking-order::buildTrackingSource',
        'uses' => 'HomeController@buildTrackingSource',
    ]);

    Route::any('/get-source', [
        'as' => 'tracking-order::getSource',
        'uses' => 'HomeController@getSource',
    ]);

    Route::get('/rebuild-tracking', [
        'as' => 'tracking-order::rebuildTracking',
        'uses' => 'HomeController@rebuildTracking',
    ]);

    Route::any('/check-device', [
        'uses' => 'HomeController@checkDetector'
    ]);

    Route::get('/delay-tracking/find', 'TrackingTimelineController@find');
    Route::get('/delay-tracking/export', 'TrackingTimelineController@export');
    Route::get('/rebuild/loss-source', 'HomeController@rebuildTrackinOrderLossSource');

    Route::group(['middleware' => config('app.system_auth_middleware')], function () {
        Route::any('/tracking', 'TrackingTimelineController@index');
    });
});
