<?php

namespace Modules\Trademarks\Controllers;

use App\Utils\EventHelper;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\Trademarks\Models\ProductModel;
use Modules\Trademarks\Controllers\Controller;
class CheckByDesignController extends HomeController
{
    public function checkAll(Request $request) {
        set_time_limit(10 * 3600);
        ini_set('memory_limit', '2048M');

        $result = [
            'designs' => [],
            'products' => []
        ];

        $query = ProductModel::query();
        if ($request->input('hours', 2)) {
            $hour = $request->input('hours', 2);
            $query->where('updated_at', '>=', date('Y-m-d H:i:s', strtotime('-' . $hour . ' hours')));
        }
        $query->where(function ($query) {
            $query->where('is_trademark', 0)
                ->orWhere('is_violation', 0);
        })
        ->where('status', 'ACTIVE');
        $step = $request->input('step', 1000);
        $fromId = $this->getFromId($request, $query);
        $toId = $this->getToId($request, $query);

        while ($fromId <= $toId) {
            $stepToId = $fromId + $step;
            if ($toId < $stepToId) {
                $stepToId = $toId;
            }
            $products = $this->getProducts($query, $fromId, $stepToId);
            $productIds = $products->pluck('id')->toArray();
            $res =  $this->getDesigns($productIds);
            $designs = $res['designs'];
            $result['designs'] = $this->checkDesigns($designs);

            $productHasDesignById = array_flip($res['product_has_design']);
            $productsNeedCheck = [];
            foreach ($products as $item) {
                if (!array_key_exists($item->id, $productHasDesignById)) {
                    $productsNeedCheck[] = $item;
                }
            }
            $result['products'] = $this->checkProducts($productsNeedCheck);
                
            $fromId += $step + 1;
        }

        return [
            'status' => 'successful',
            'result' => $result
        ];
    }

    public function checkDesigns($designs) {
        $retVal = [];
        foreach($designs as $design) {
            $checkResult = [];
            $checkResult = array_merge($checkResult, $this->checkTextTrademarks($design->name));
            $checkResult = array_merge($checkResult, $this->checkTextViolation($design->name));
            $checkResult = array_merge($checkResult, $this->checkTextWarning($design->name));

            if (count($checkResult)) {
                $this->updateProductsByDesign($design, $checkResult);
                DB::table('small_design')
                    ->where('id', $design->id)
                    ->update([
                        'status' => 'PENDING'
                    ]);
                $retVal[] = $design->id;
            }
        }

        return $retVal;
    }

    public function updateProductsByDesign($design, $trademarks) {
        $productIds = DB::table('product_n_design')->where('design_id', $design->id)->get(['product_id'])->pluck('product_id')->toArray();
        foreach ($trademarks as $trademark) {
            $this->updateProduct($productIds, $trademark);
        }
    }

    public function updateProduct($productIds, $trademark) {
        $updateData = [];
        $productNTrademark = [
            'trademark_id' => $trademark->id,
            'type' => $trademark->type
        ];
        switch ($trademark->type) {
            case 'trademark':
                $updateData = [
                    'updated_at' => date('Y-m-d H:i:s', time())
                ];
                $updateData['is_trademark'] = 1;
                $updateData['status'] = 'PENDING';
                break;
            case 'violation':
                $updateData = [
                    'updated_at' => date('Y-m-d H:i:s', time())
                ];
                $updateData['is_violation'] = 1;
                break;
            default:
                break;
        }
        if (count($updateData)) {
            foreach (array_chunk($productIds, 100) as $partIds) {
                if ($trademark->type == 'trademark') {
                    DB::table('product')->whereIn('id', $partIds)->where(function ($query) {
                        $query->where('is_trademark', 0)
                            ->orWhere('status', 'ACTIVE');
                    })->update($updateData);
                    EventHelper::pushEvent('bulkHideProduct', ['ids' => $partIds]);
                } else if ($trademark->type == 'violation') {
                    DB::table('product')->whereIn('id', $partIds)->where('is_violation', 0)->update($updateData);
                    EventHelper::pushEvent('bulkProductIsViolation', ['ids' => $partIds]);
                }
            }
        }

        $insertData = [];
        $existIds = DB::table('product_n_trademark')->where('trademark_id', $trademark->id)->whereIn('product_id', $productIds)->get(['product_id'])->pluck('product_id')->toArray();
        $productIds = array_diff($productIds, $existIds);
        foreach ($productIds as $productId) {
            $tmpData = $productNTrademark;
            $tmpData['product_id'] = $productId;
            $tmpData['created_at'] = date('Y-m-d H:i:s', time());
            $tmpData['updated_at'] = date('Y-m-d H:i:s', time());
            $insertData[] = $tmpData;
        }

        foreach (array_chunk($insertData, 100) as $tmpData) {
            DB::table('product_n_trademark')->insert($tmpData);
        }
    }

    public function getProducts($query, $fromId, $toId) {
        $cloneQuery = clone $query;
        return $cloneQuery->orderBy('id', 'asc')
            ->where('id', '>=', $fromId)
            ->where('id', '<=', $toId)
            ->get(['id', 'name', 'description', 'content', 'trademarks', 'is_trademark', 'is_violation', 'status']);
    }

    public function getDesigns($productIds) {
        $pnt = DB::table('product_n_design')
            ->whereIn('product_id', $productIds)
            ->get();
        $designIds = array_unique($pnt->pluck('design_id')->toArray());
        $hasDesignProductIds = $pnt->pluck('product_id')->toArray();
        $designs = DB::table('design')->whereIn('id', $designIds)->get(['id', 'name']);

        return [
            'designs' => $designs,
            'product_has_design' => $hasDesignProductIds
        ];
    }

    public function getFromId($request, $query, $orderField = 'created_at', $getField = 'id') {
        if ($request->input('minId')) {
            return $request->input('minId');
        }
        $cloneQuery = clone $query;

        $from = $cloneQuery->orderBy($orderField, 'asc')->first();
        if ($from) {
            return $from->{$getField};
        }

        return 0;
    }

    public function getToId($request, $query, $orderField = 'created_at', $getField = 'id') {
        if ($request->input('maxId')) {
            return $request->input('maxId');
        }
        $cloneQuery = clone $query;

        $to = $cloneQuery->orderBy($orderField, 'desc')->first();
        if ($to) {
            return $to->{$getField};
        }

        return 0;
    }
}
