<?php

namespace Modules\Trademarks\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Modules\Trademarks\Controllers\Controller;
use App\Utils\EventHelper;
use Illuminate\Support\Facades\Redis;

class CheckBySearchServiceController extends Controller
{
    public function check(Request $request) {
        $cacheKey = decorCacheKey('check_trademark_by_search');
        if ($request->has('product_hours')) {
            $cacheKey = $cacheKey . '_propduct';
        } else {
            $cacheKey = $cacheKey . '_keyword';
        }
        if (Redis::exists($cacheKey) && !$request->has('clear_cache')) {
            $retVal['result'] = Redis::get($cacheKey);
            return $retVal;
        } else {
            Redis::set($cacheKey, 1 , 'EX', 60 * 60 * 6);
        }
        set_time_limit(3 * 3600);
        $keywords = $this->getTrademarksKeywords($request);
        $result = [];
        $minId = 0;
        if ($request->get('product_hours')) {
            $minProd = DB::table('product')->where('created_at', '>=', date('Y-m-d H:00:00', time() - $request->get('product_hours') * 3600))
                ->orderBy('created_at', 'asc')
                ->first(['id']);
            if ($minId) {
                $minId = $minProd->id;
            }
        }
        foreach ($keywords as $keyword) {
            $this->checkKeyword($keyword, $result, $minId, 0);
        }
        Redis::del($cacheKey);
        return [
            'status' => 'successful',
            'result' => $result
        ];
    }

    protected function getTrademarksKeywords ($request) {
        $query = DB::table('trademarks');
        if ($request->get('trademark_ids')) {
            $query->whereIn('id', explode(',', $request->get('trademark_ids')));
        }
        if (!$request->get('all_keywords')) {
            $query->where('updated_at', '>=', date('Y-m-d H:i:s', strtotime('-' . $request->get('hour', 2) . ' hours')));
        }
        $query->where('status', 'ACTIVE');
        $query->whereIn('type', explode(',', $request->get('types', 'trademark,violation,warning')));
        $keywords = $query->get(['keyword', 'type', 'id'])->toArray();
        $retVal = [];
        foreach ($keywords as $item) {
            $item->keyword = $this->replaceKeyword($item->keyword);
            $retVal[] = $item;
        }
        return $retVal;
    }

    protected function replaceKeyword($keyword) {
        $keyword = strtolower(trim($keyword));
        $keyword = str_replace(' and ', ' ', $keyword);
        $keyword = str_replace('\\', '\\\\', $keyword);
        $keyword = str_replace('/', '\/', $keyword);
        $keyword = str_replace('.', '\.', $keyword);

        return $keyword;
    }

    protected function getLocalePrefix() {
        $locale = env('APP_LOCALE', config('localization::module.default_locale', 'us'));
        if (!$locale || $locale == config('localization::module.default_locale', 'us')) {
            $locale = '';
        } else {
            $locale = '/' . $locale;
        }

        return $locale;
    }

    private function checkKeyword($trademark, &$retVal, $minId, $pageId = 0) {
        $url = config('app.url') . $this->getLocalePrefix() . "/z-search/trademark/search?page_size=1000&q="  . urlencode($trademark->keyword) . '&page_id=' . $pageId;
        if ($minId) {
            $url .= '&from_id=' . $minId;
        }

        $result = $this->triggerSyncRequest($url);
        if (!empty($result['result'])) {
            $productIds = [];
            foreach ($result['result'] as $item) {
                $productIds[] = $item['id'];
            }

            $highRiskProductIds = DB::table('product_meta')
                ->whereIn('product_id', $productIds)
                ->where('key', 'is_high_risk')
                ->where('value', 1)
                ->pluck('product_id')
                ->toArray();
            $productIds = array_diff($productIds, $highRiskProductIds);
            if (count($productIds)) {
                $this->updateProduct($trademark, $productIds);
                $retVal = array_merge($retVal, $productIds);
            }

            if (!empty($result['meta']['has_next'])) {
                $this->checkKeyword($trademark, $retVal, $minId, ++$pageId);
            }
        }
    }

    public function updateProduct($trademark, $productIds) {
        $updateData = [];
        $productNTrademark = [
            'trademark_id' => $trademark->id,
            'type' => $trademark->type
        ];
        switch ($trademark->type) {
            case 'trademark':
                $updateData = [
                    'updated_at' => date('Y-m-d H:i:s', time())
                ];
                $updateData['is_trademark'] = 1;
                $updateData['status'] = 'PENDING';
                break;
            case 'violation':
                $updateData = [
                    'updated_at' => date('Y-m-d H:i:s', time())
                ];
                $updateData['is_violation'] = 1;
                break;
            default:
                break;
        }
        if (count($updateData)) {
            foreach (array_chunk($productIds, 100) as $partIds) {
                if ($trademark->type == 'trademark') {
                    DB::table('product')->whereIn('id', $partIds)->where(function ($query) {
                        $query->where('is_trademark', 0)
                            ->orWhere('status', 'ACTIVE');
                    })->update($updateData);
                    // EventHelper::pushEvent('bulkHideProduct', ['ids' => $partIds]);
                } else if ($trademark->type == 'violation') {
                    DB::table('product')->whereIn('id', $partIds)->where('is_violation', 0)->update($updateData);
                    // EventHelper::pushEvent('bulkProductIsViolation', ['ids' => $partIds]);
                }
            }
        }

        $insertData = [];
        $existIds = DB::table('product_n_trademark')->where('trademark_id', $trademark->id)->whereIn('product_id', $productIds)->get(['product_id'])->pluck('product_id')->toArray();
        $productIds = array_diff($productIds, $existIds);
        foreach ($productIds as $productId) {
            $tmpData = $productNTrademark;
            $tmpData['product_id'] = $productId;
            $tmpData['created_at'] = date('Y-m-d H:i:s', time());
            $tmpData['updated_at'] = date('Y-m-d H:i:s', time());
            $insertData[] = $tmpData;
        }

        foreach (array_chunk($insertData, 100) as $tmpData) {
            DB::table('product_n_trademark')->insert($tmpData);
        }
    }
}
