<?php

namespace Modules\Trademarks\Controllers;

use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Routing\Controller as BaseController;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;

    protected function triggerSyncRequest($url, $method = 'GET', $params = [], $headers = [], $timeout = 120) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);

        $headers[] = 'Content-Type:application/json';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
        if ($method != 'GET') {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($params));
        }
        curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
        curl_setopt($ch, CURLOPT_TIMEOUT, $timeout);
        $data = curl_exec($ch);
        if (curl_errno($ch)) {
            \Log::info('triggerSyncRequest', [$url]);
            \Log::info('triggerSyncRequest ERROR', [curl_error($ch)]);
        }
        curl_close($ch);
        $retval = json_decode($data, true);
        if (!$retval) {
            return $data;
        }
        return $retval;
    }

    protected function triggerAsyncRequest($url, $method = "GET", $params = [], $headers = [], $timeout = 5) {
        $channel = curl_init();
        curl_setopt($channel, CURLOPT_URL, $url);
        // curl_setopt($channel, CURLOPT_NOSIGNAL, 1);
        curl_setopt($channel, CURLOPT_TIMEOUT, $timeout);
        curl_setopt($channel, CURLOPT_RETURNTRANSFER, 1);
        if($method == "post" || $method == "POST") {
            curl_setopt($channel, CURLOPT_POST, true);
            curl_setopt($channel, CURLOPT_POSTFIELDS, json_encode($params));
        }
        $headers[] = 'Content-type: application/json';
        if ($headers) {
            curl_setopt($channel, CURLOPT_HTTPHEADER, $headers);
        }
        curl_setopt($channel, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($channel, CURLOPT_SSL_VERIFYPEER, 0);
        $data = curl_exec($channel);
        if (curl_errno($channel)) {
            \Log::info('triggerAsyncRequest', [$url]);
            \Log::info('triggerAsyncRequest ERROR', [curl_error($channel)]);
        }
        curl_close($channel);
        $retval = json_decode($data, true);
        if (!$retval) {
            return $data;
        }
        return $retval;
    }
}
