<?php

namespace Modules\Trademarks\Controllers;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Modules\Localization\Helpers\DBConnect;
use Modules\Trademarks\Controllers\Controller;
use Module;
use Modules\Trademarks\Models\OptionModel;
use Modules\Trademarks\Models\ProductModel;

class DesignTrademarkController extends Controller
{
    public function checkViolation(Request $request) {
        set_time_limit(10 * 3600);
        ini_set('memory_limit', '2048M');
        $query = DB::table('small_design');
        if ($request->input('status')) {
            $query->where('status', $request->input('status'));
        } else {
            $query->where('status', 'ACTIVE');
        }
        $step = $request->input('step', 10000);
        $fromId = $this->getFromId($request, $query);
        $toId = $this->getToId($request, $query);
        if ($request->input('hour')) {
            $hour = $request->input('hour');
            $query->where('updated_at', '>=', date('Y-m-d', strtotime('-' . $hour . ' hours')));
        }
        $retVal = [
            'status' => 'successful',
            'result' => []
        ];
        while ($fromId <= $toId) {
            $stepToId = $fromId + $step + 1;
            if ($toId < $stepToId) {
                $stepToId = $toId;
            }
            $cloneQuery = clone $query;
            $designIds = $cloneQuery
                ->where('id', '>=', $fromId)
                ->where('id', '<=', $stepToId)
                ->get(['design_id'])
                ->pluck('design_id');
            foreach ($designIds as $designId) {
                $productIds = DB::table('product_n_design')
                    ->where('design_id', $designId)
                    ->get(['product_id'])
                    ->pluck('product_id');
                $exists = DB::table('product_n_trademark')
                    ->whereIn('product_id', $productIds)
                    ->exists();
                if ($exists) {
                    DB::table('small_design')
                        ->where('id', $designId)
                        ->update([
                            'status' => 'PENDING'
                        ]);
                    $retVal['result'][] = $designId;
                } else if ($request->input('status') == 'PENDING') {
                    DB::table('small_design')
                        ->where('id', $designId)
                        ->update([
                            'status' => 'ACTIVE'
                        ]);
                    $retVal['result'][] = $designId;
                }
            }

            $fromId += $step;
        }

        return $retVal;
    }

    public function getFromId($request, $query) {
        if ($request->input('minId')) {
            return $request->input('minId');
        }
        $cloneQuery = clone $query;

        $from = $cloneQuery->orderBy('id', 'asc')->first();
        if ($from) {
            return $from->id;
        }

        return 0;
    }

    public function getToId($request, $query) {
        if ($request->input('maxId')) {
            return $request->input('maxId');
        }
        $cloneQuery = clone $query;

        $to = $cloneQuery->orderBy('id', 'desc')->first();
        if ($to) {
            return $to->id;
        }

        return 0;
    }
}
