<?php

namespace Modules\Trademarks\Controllers;

use App\Utils\Email;
use App\Utils\EventHelper;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Modules\Trademarks\Models\ProductModel;
use Modules\Trademarks\Service\HideProductService;

class HideProductController extends Controller
{
    private $hideProductService;
    public function __construct(HideProductService $hideProductService)
    {
        $this->hideProductService = $hideProductService;
    }

    public function index() {
        return view('trademarks::hide-product.hide-by-link');
    }

    public function updateIsTradmark(Request $request) {
        $retVal = [
            'status' => 'successful',
            'result' => 0,
        ];
        $token = $request->header('token');
        $user = DB::table('users')
            ->where('token', $token)
            ->whereIn('role', ['STAFF', 'ADMIN'])
            ->where('status', 'ACTIVE')
            ->first(['id', 'email']);

        if (!$user) {
            return [
                'status' => 'fail',
                'message' => 'Permission denied'
            ];
        }

        if ($request->has('product_ids') && $request->has('is_trademark')) {
            $ids = $request->get('product_ids');
            $ids = explode(',', $ids);
            foreach ($ids as $id) {
                $product = ProductModel::find($id);
                $product->is_trademark = $request->get('is_trademark');
                $product->save();
            }
            if ($request->get('is_trademark')) {
                $result = $this->hideProductService->productIdsGroupBySeller($ids);
                foreach ($result as $item) {
                    $this->hideProductService->sendEmailHideProduct($item['user'], $item['products']);
                }
            } 
            $retVal['result'] = 1;
        }
        return $retVal;
    }

    public function hideProductByIds(Request $request)
    {
        set_time_limit(1800);

        $result = [];
        $token = $request->header('token');
        $user = DB::table('users')
            ->where('token', $token)
            ->whereIn('role', ['STAFF', 'ADMIN'])
            ->where('status', 'ACTIVE')
            ->first(['id', 'email']);

        if (!$user) {
            return [
                'status' => 'fail',
                'message' => 'Permission denied'
            ];
        }

        $result = $this->hideProductService->hideProductByIds($user, $request->all());

        return [
            'status' => 'successful',
            'result' => $result
        ];
    }

    public function markViolationProductByIds(Request $request)
    {
        set_time_limit(1800);

        $result = [];
        $token = $request->header('token');
        $user = DB::table('users')
            ->where('token', $token)
            ->whereIn('role', ['STAFF', 'ADMIN'])
            ->where('status', 'ACTIVE')
            ->first(['id', 'email']);

        if (!$user) {
            return [
                'status' => 'fail',
                'message' => 'Permission denied'
            ];
        }
        $productIds = explode(',', $request->get('product_ids', ''));
        $updateData = [
            'is_violation' => 1,
            'updater_id' => $user->id,
            'updated_at' => date('Y-m-d H:i:s'),
        ];


        DB::table('product')->whereIn('id', $productIds)
            ->update($updateData);
        $result = array_merge($result, $productIds);
        $logData = [];
        foreach ($productIds as $productId) {
            $logData[] = [
                'actor_email' => $user ? $user->email : '',
                'target_type' => 'PRODUCT',
                'target_id' => $productId,
                'event_type' => 'UPDATE',
                'data' => json_encode($updateData),
                'created_at' => date('Y-m-d H:i:s', time())
            ];
        }

        if($request->get('hide_same_design')) {
            $designIds = DB::table('product_n_design')->whereIn('product_id', $productIds)->get(['design_id'])->pluck('design_id');
            $sameDesignProductIds = DB::table('product_n_design')
                ->whereNotIn('product_id', $productIds)
                ->whereIn('design_id', $designIds)
                ->get(['product_id'])
                ->pluck('product_id')
                ->toArray();
            
            DB::table('product')->whereIn('id', $sameDesignProductIds)
                ->update($updateData);

            foreach ($sameDesignProductIds as $productId) {
                $logData[] = [
                    'actor_email' => $user ? $user->email : '',
                    'target_type' => 'PRODUCT',
                    'target_id' => $productId,
                    'event_type' => 'UPDATE',
                    'data' => json_encode($updateData),
                    'created_at' => date('Y-m-d H:i:s', time())
                ];
            }

            $result = array_merge($result, $sameDesignProductIds);

            DB::table('small_design')->whereIn('design_id', $designIds)
                ->update([
                    'status' => 'PENDING',
                    'updated_at' => new \DateTime(),
                ]);
        }

        if (count($logData)) {
            DB::table('log')->insert($logData);
        }
        $result = $this->hideProductService->productIdsGroupBySeller($result);

        return [
            'status' => 'successful',
            'result' => $result
        ];
    }
}
