<?php

namespace Modules\Trademarks\Controllers;

use Modules\Trademarks\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class ImpactKeywordController extends Controller
{

    public function __construct()
    {

        
    }

    public function index()
    {
        return view('trademarks::impact-keyword.index');
    }

    public function checkKeyword(Request $request)
    {
        $retVal = [
            'status' => 'successful',
            'result' => []
        ];
        $keyword = $request->input('keyword');
        $retVal['result']['count_hide_products'] = 0;
        $retVal['result']['count_hide_feed_products'] = 0;
        $retVal['result']['count_orders'] = 0;
        $this->count($keyword, $retVal);
        return response()->json($retVal);
    }
   
    protected function getLocalePrefix() {
        $locale = env('APP_LOCALE', config('localization::module.default_locale', 'us'));
        if (!$locale || $locale == config('localization::module.default_locale', 'us')) {
            $locale = '';
        } else {
            $locale = '/' . $locale;
        }

        return $locale;
    }

    private function count($keyword, &$retVal, $pageId = 0) {
        $url = config('app.url') . $this->getLocalePrefix() . "/z-search/trademark/search?page_size=1000&q="  . urlencode($keyword) . '&page_id=' . $pageId;

        $result = $this->triggerSyncRequest($url);
        if (!empty($result['result'])) {
            $productIds = [];
            foreach ($result['result'] as $item) {
                $productIds[] = $item['id'];
            }
            $retVal['result']['count_hide_products'] += $this->countHideProducts($productIds);
            $retVal['result']['count_hide_feed_products'] += $this->countHideFeedProducts($productIds);
            $retVal['result']['count_orders'] += $this->countOrders($productIds);

            if (!empty($result['meta']['has_next'])) {
                $this->count($keyword, $retVal, ++$pageId);
            }
        }
    }

    private function countOrders ($productIds)
    {
        return DB::table('order')
            ->join('order_item as oi', 'oi.order_id', '=', 'order.id')
            ->where('order.payment_status', 'PAID')
            ->whereIn('oi.product_id', $productIds)
            ->groupBy('order.id')
            ->get()
            ->count();
    }

    private function countHideProducts ($productIds)
    {
        return DB::table('product')->whereIn('id', $productIds)
                ->where('status', 'ACTIVE')
                ->get()
                ->count();
    }

    private function countHideFeedProducts ($productIds)
    {
        return DB::table('product')->whereIn('id', $productIds)
                ->where('status', 'ACTIVE')
                ->where('approve_advertising', 1)
                ->where('is_violation', 0)
                ->where('is_trademark', 0)
                ->get()
                ->count();
    }
}


