<?php

namespace Modules\Trademarks\Controllers\Impl;

use DB;
use DateTime;

class LanguageChecker {
    use RequestTrait;
    
    public function check($products) {
        $parmas = [
            "data" => $this->buildCheckData($products)
        ];
        $res = $this->syncRequest('https://language-detector.megaads.fun/detect', 'POST', $parmas);

        if (isset($res['message']) && $res['message'] === 'Successful') {
            $data = $res['result'];
            $saveData = $this->buildSaveData($data, $this->getDefaultLanguage());
            $this->saveWarning($saveData);
        }

        return $res;
    }

    public function getDefaultLanguage() {
        $locale = env('APP_LOCALE', 'us');
        if (!$locale) {
            $locale = 'us';
        }

        $languageMapping = [
            'en' => ['us', 'uk', 'au', 'ca'],
            'fr' => ['fr'],
            'de' => ['de'],
            'es' => ['es'],
            'fr' => ['fr'],
            'it' => ['it'],
            'jp' => ['jp'],
            'pt' => ['pt'],
            'kr' => ['kr'],
        ];

        foreach ($languageMapping as $lang => $locales) {
            if (in_array($locale, $locales)) {
                return $lang;
            }
        }

        return $locale;
    }

    public function buildSaveData($data, $defaultLanguage) {
        $insertData = [];
        $updateData = [];
        $deleteIds = [];
        foreach ($data as $key => $languages) {
            $isExisted = DB::table('product_language_warning')->where('product_id', $key)->exists();
            $otherLanguages = [];
            foreach ($languages as $lang) {
                if ($lang != $defaultLanguage) {
                    $otherLanguages[] = $lang;
                };
            }
            if (count($otherLanguages) > 0) {
                if ($isExisted) {
                    $updateData[] = [
                        'product_id' => $key, 
                        'other_language' => implode(',', $otherLanguages),
                    ];
                } else {
                    $insertData[] = [
                        'product_id' => $key, 
                        'other_language' => implode(',', $otherLanguages),
                        'created_at' => new DateTime(),
                        'updated_at' => new DateTime(),
                    ];
                }
            } else if ($isExisted) {
                $deleteIds[] = $key;
            }
        }
        return [
            'insertData' => $insertData,
            'updateData' => $updateData,
            'deleteIds' => $deleteIds
        ];
    }

    public function saveWarning($saveData) {
        if (count($saveData['insertData']) > 0) {
            $isInsert = DB::table('product_language_warning')->insert($saveData['insertData']);
            $retVal['result'] = $isInsert;
        }

        if (count($saveData['updateData'])) {
            foreach (array_chunk($saveData['updateData'], 100) as $partItems) {
                $updateTime = date('Y-m-d H:i:s', time());
                $updateSql = 'UPDATE sb_product_language_warning `plw` join (';
                foreach ($partItems as $key => $value) {
                    if ($key == 0) {
                        $updateSql .= ('SELECT ' . $value['product_id'] . " as `product_id`, '" . $value['other_language'] . "' as `new_other_language`, '" . $updateTime . "' as `new_updated_at`" );
                    } else {
                        $updateSql .= ('UNION ALL SELECT ' . $value['product_id'] . " , '" . $value['other_language'] . "', '" . $updateTime . "'");
                    }
                }

                $updateSql .= ' ) `values` ON `plw`.product_id = `values`.product_id SET `other_language` = `new_other_language`, `updated_at` = `new_updated_at`';
                DB::statement($updateSql);
            }
        }

        if (count($saveData['deleteIds']) > 0) {
            DB::table('product_language_warning')->whereIn('product_id', $saveData['deleteIds'])->delete();
        }
    }

    public function decorName($text) {
        $text = preg_replace("/[^A-Za-z ]/", ' ', $text);
        $text = trim(preg_replace('/\s\s+/', ' ', str_replace("\n", " ", $text)));

        return $text;
    }

    protected function decorKeyword($keyword) {
        $keyword = strtolower(trim($keyword));
        $keyword = str_replace('\\', '\\\\', $keyword);
        $keyword = str_replace('/', '\/', $keyword);
        $keyword = str_replace('.', '\.', $keyword);

        return $keyword;
    }

    public function buildCheckData(&$products) {
        $data = [];
        foreach ($products as &$product) {
            $name = $this->decorName($product->name);
            $ignoreKeywords = DB::table('product_language_warning_ignore_keyword')->get();
    
            foreach ($ignoreKeywords as $item) {
                $item->keyword = $this->decorKeyword($item->keyword);
                $name = trim(preg_replace("/\b" . $item->keyword . "\b/i", "", $name));
            }
            $data[] = [
                'code' => $product->id,
                'content' => $name
            ];
        }

        return $data;
    }
}
