<?php

namespace Modules\Trademarks\Controllers\Impl;

trait RequestTrait {

    public function syncRequest($url, $method = "GET", $params = [], $headers = [], $timeout = 120) {
        $channel = curl_init();
        curl_setopt($channel, CURLOPT_URL, $url);
        // curl_setopt($channel, CURLOPT_NOSIGNAL, 1);
        curl_setopt($channel, CURLOPT_TIMEOUT, $timeout);
        curl_setopt($channel, CURLOPT_RETURNTRANSFER, 1);
        if($method == "post" || $method == "POST") {
            curl_setopt($channel, CURLOPT_POST, true);
            curl_setopt($channel, CURLOPT_POSTFIELDS, json_encode($params));
        }
        $headers[] = 'Content-type: application/json';
        if ($headers) {
            curl_setopt($channel, CURLOPT_HTTPHEADER, $headers);
        }
        curl_setopt($channel, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($channel, CURLOPT_SSL_VERIFYPEER, 0);
        $data = curl_exec($channel);
        if (curl_errno($channel)) {
            \Log::info('crawl syncRequest ERROR', [curl_error($channel), curl_errno($channel)]);
        }
        curl_close($channel);
        $response = json_decode($data, true);
        if (!$response) {
            return $data;
        }
        return $response;
    }

    public function asyncRequest($url, $method = "GET", $params = [], $headers = [], $timeout = 120) {
        $channel = curl_init();
        if ($method == "get" || $method == "GET") {
            curl_setopt($channel, CURLOPT_URL, $url . "?" . $params);
        } else if ($method == "post" || $method == "POST") {
            curl_setopt($channel, CURLOPT_URL, $url);
            curl_setopt($channel, CURLOPT_POST, true);
            curl_setopt($channel, CURLOPT_POSTFIELDS, $params);
        }
        curl_setopt($channel, CURLOPT_NOSIGNAL, 1);
        curl_setopt($channel, CURLOPT_TIMEOUT, $timeout);
        curl_setopt($channel, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($channel, CURLOPT_SSL_VERIFYHOST, 0);
        curl_setopt($channel, CURLOPT_SSL_VERIFYPEER, 0);
        $data = curl_exec($channel);
        if (curl_errno($channel)) {
            \Log::info('crawl asyncRequest ERROR', [curl_error($channel), curl_errno($channel)]);
        }
        curl_close($channel);

        $response = json_decode($data, true);
        if (!$response) {
            return $data;
        }
        return $response;
    }
}