<?php

namespace Modules\Trademarks\Controllers;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Modules\Trademarks\Controllers\Controller;
use Maatwebsite\Excel\Facades\Excel;

class ImportController extends Controller
{
    public function export(Request $request) {
        set_time_limit(600);
        $data = $this->getTrademarkData();
        @ob_clean();
        @ob_flush();
        Excel::create('Trademark_List_'.env('APP_LOCALE').'_'. date('Y-m-d'), function ($excel) use ($data) {
            // Set the title
            $excel->setTitle('Trademark '. env('APP_LOCALE'));

            // Chain the setters
            $excel->setCreator('Megaads')
                ->setCompany('Megaads');

            $excel->sheet('trademark', function ($sheet) use ($data) {

                foreach ($data as $value) {
                    $sheet->appendRow($value);
                }
            });
        })->download('xlsx');
    }

    private function getTrademarkData(){
        ini_set("memory_limit", "3072M");
        $items = \DB::table('trademarks')->orderBy('id', 'desc')->get();
        $retVal = [['keyword', 'link', 'image', 'type', 'status']];
        foreach ($items as $item) {
            $retVal[] = [$item->keyword, $item->link, $item->image_url, $item->type, $item->status];
        }
        
        return $retVal;
    }

    public function exportViolationKeyword(Request $request) {
        set_time_limit(600);
        $data = $this->getViolationData();
        Excel::create('Violation_List_'.env('APP_LOCALE').'_'. date('Y-m-d'), function ($excel) use ($data) {
            // Set the title
            $excel->setTitle('Violation '. env('APP_LOCALE'));

            // Chain the setters
            $excel->setCreator('Megaads')
                ->setCompany('Megaads');

            $excel->sheet('violation', function ($sheet) use ($data) {

                foreach ($data as $value) {
                    $sheet->appendRow($value);
                }
            });
        })->download('xlsx');
    }

    private function getViolationData(){
        ini_set("memory_limit", "3072M");
        $option = \DB::table('option')->where('key', 'ads_violation_keywords')->first();
        
        $retVal = [['keyword']];
        if ($option) {
            $items = json_decode($option->value);
            if (!empty($items)) {
                foreach ($items as $item) {
                    $retVal[] = [$item];
                }
            }
        }
        
        return $retVal;
    }

    public function import(Request $request) {
        set_time_limit(3600);

        $items = $request->get('items');
        $insertData = [];
        foreach ($items as $item) {
            $data = [
                'keyword' => trim($item['keyword']),
                'link' => isset($item['link']) ? trim($item['link']) : '',
                'image_url' => isset($item['image']) ? trim($item['image']) : '',
                'type' => isset($item['type']) ? trim($item['type']) : 'trademark',
                'status' => isset($item['status']) ? trim($item['status']) : 'ACTIVE',
                'created_at' => date('Y-m-d H:i:s', time()),
                'updated_at' => date('Y-m-d H:i:s', time()),
            ];
            $exist = \DB::table('trademarks')->where('keyword', $data['keyword'])->exists();
            if (!$exist) {
                $insertData[] = $data;
            }
        }
        \DB::table('trademarks')->insert($insertData);

        return [
            'status' => 'successful',
        ];
    }

    public function importViolationKeyword(Request $request) {
        set_time_limit(3600);

        $items = $request->get('items');
        $data = [];
        foreach ($items as $item) {
            $data[] = trim($item['keyword']);
        }
        $option = \DB::table('option')->where('key', 'ads_violation_keywords')->first();
        if ($option) {
            $value = json_decode($option->value);
            if ($value) {
                $value = array_values(array_unique(array_merge($value, $data)));
            } else {
                $value = $data;
            }
            \DB::table('option')->where('id', $option->id)
                ->update([
                    'value' => json_encode($value)
                ]);
        } else {
            \DB::table('option')->insert([
                'key' => 'ads_violation_keywords',
                'value' => json_encode($data),
                'created_at' => date('Y-m-d H:i:s', time()),
                'updated_at' => date('Y-m-d H:i:s', time()),
            ]);
        }

        return [
            'status' => 'successful',
        ];
    }

    public function exportKeywordReplacement(Request $request) {
        set_time_limit(600);
        $data = $this->getKeywordReplacementData();
        Excel::create('KeywordReplacement_List_'.env('APP_LOCALE').'_'. date('Y-m-d'), function ($excel) use ($data) {
            // Set the title
            $excel->setTitle('KeywordReplacement '. env('APP_LOCALE'));

            // Chain the setters
            $excel->setCreator('Megaads')
                ->setCompany('Megaads');

            $excel->sheet('KeywordReplacement', function ($sheet) use ($data) {

                foreach ($data as $value) {
                    $sheet->appendRow($value);
                }
            });
        })->download('xlsx');
    }

    private function getKeywordReplacementData(){
        ini_set("memory_limit", "3072M");
        $items = \DB::table('trademark_keyword_replacement')
            ->orderBy('sorder', 'desc')
            ->orderBy('id', 'desc')->get();
        $retVal = [['keyword', 'replace_keyword', 'sorder']];
        foreach ($items as $item) {
            $retVal[] = [$item->keyword, $item->replace_keyword, $item->sorder];
        }
        
        return $retVal;
    }

    public function importKeywordReplacement(Request $request) {
        set_time_limit(3600);

        $items = $request->get('items');
        $insertData = [];
        foreach ($items as $item) {
            $data = [
                'keyword' => trim($item['keyword']),
                'replace_keyword' => isset($item['replace_keyword']) ? trim($item['replace_keyword']) : '',
                'sorder' => isset($item['sorder']) ? trim($item['sorder']) : '0',
                'created_at' => date('Y-m-d H:i:s', time()),
                'updated_at' => date('Y-m-d H:i:s', time()),
            ];
            $exist = \DB::table('trademark_keyword_replacement')->where('keyword', $data['keyword'])->exists();
            if (!$exist) {
                $insertData[] = $data;
            }
        }
        \DB::table('trademark_keyword_replacement')->insert($insertData);

        return [
            'status' => 'successful',
        ];
    }

    public function exportSeller(Request $request) {
        set_time_limit(600);
        $data = $this->getTrademarkSellerData();
        @ob_clean();
        @ob_flush();
        Excel::create('Trademark_Seller_List_'.env('APP_LOCALE').'_'. date('Y-m-d'), function ($excel) use ($data) {
            // Set the title
            $excel->setTitle('Trademark Seller '. env('APP_LOCALE'));

            // Chain the setters
            $excel->setCreator('Megaads')
                ->setCompany('Megaads');

            $excel->sheet('trademark-seller', function ($sheet) use ($data) {

                foreach ($data as $value) {
                    $sheet->appendRow($value);
                }
            });
        })->download('xlsx');
    }

    private function getTrademarkSellerData(){
        ini_set("memory_limit", "3072M");
        $items = \DB::table('seller_trademarks_keyword')->orderBy('id', 'desc')->get();
        $retVal = [['keyword', 'link', 'image', 'type', 'status']];
        foreach ($items as $item) {
            $retVal[] = [$item->keyword, $item->link, $item->image_url, $item->type, $item->status];
        }

        return $retVal;
    }

    public function importSeller(Request $request) {
        set_time_limit(3600);

        $items = $request->get('items');
        $insertData = [];
        foreach ($items as $item) {
            $data = [
                'keyword' => trim($item['keyword']),
                'link' => isset($item['link']) ? trim($item['link']) : '',
                'image_url' => isset($item['image']) ? trim($item['image']) : '',
                'type' => isset($item['type']) ? trim($item['type']) : 'trademark',
                'status' => isset($item['status']) ? trim($item['status']) : 'ACTIVE',
                'created_at' => date('Y-m-d H:i:s', time()),
                'updated_at' => date('Y-m-d H:i:s', time()),
            ];
            $exist = \DB::table('seller_trademarks_keyword')->where('keyword', $data['keyword'])->exists();
            if (!$exist) {
                $insertData[] = $data;
            }
        }
        \DB::table('seller_trademarks_keyword')->insert($insertData);

        return [
            'status' => 'successful',
        ];
    }
}
