<?php

namespace Modules\Trademarks\Controllers;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Modules\Trademarks\Controllers\Controller;

class ImportViolationProductController extends Controller
{
    public function import(Request $request) {
        set_time_limit(3600);
        ini_set('memory_limit', '1024M');

        $input = $request->all();
        $file = fopen($input['file']['url'], 'r');
        $isFirstLine = true;
        $countryToLocale = [
            'gb' => 'uk'
        ];
        $violationData = [];
        while (($line = fgetcsv($file)) !== FALSE) {
            if (!$isFirstLine) {
                try {
                    $sku = $line[0];
                    $country = strtolower($line[1]);
                    $locale = isset($countryToLocale[$country]) ? $countryToLocale[$country] : $country;
                    $violationData[$locale][] = $sku;
                } catch (\Exception $ex) {
                    \Log::info('ImportViolationProductController ERROR', [$ex->getMessage() . ' Line: ' . $ex->getLine() . ' File: ' . $ex->getFile()]);
                }
            }
            $isFirstLine = false;
        }
        fclose($file);
        $currentLocale = env('APP_LOCALE', 'us');
        if (!$currentLocale) {
            $currentLocale = 'us';
        }
        $availableLocales = $this->getLocales();
        foreach ($violationData as $locale => $skus) {
            foreach (array_chunk($skus, 1000) as $partSkus) {
                if ($locale == $currentLocale || count($availableLocales) <= 1) {
                    $newRequest = new Request();
                    $newRequest->merge([
                        'skus' => $partSkus,
                        'token' => 'megaads@123'
                    ]);
    
                    $this->setViolationProduct($newRequest);
                } else {
                    $this->triggerSyncRequest(
                        url('/') . ($locale != 'us' ? '/' . $locale . '/' : '/') . 'trademarks/set-violation-product',
                        'POST',
                        ['skus' => $partSkus, 'token' => 'megaads@123'],
                        ['Content-type: application/json'],
                        10
                    );
                }
            }
        }

        return [
            'status' => 'successful',
        ];
    }

    private function getLocales () {
        $retVal = [];
        $locales = config('localization::module.locales', []);

        foreach ($locales as $key => $item) {
            if (isset($item['enable']) && $item['enable']) {
                $retVal[] = $key;
            }
        }

        return $retVal;
    }

    public function setViolationProduct(Request $request) {        
        set_time_limit(3600);
        ini_set('memory_limit', '1024M');

        if ($request->get('token') != 'megaads@123') {
            return [
                'status' => 'fail',
                'message' => 'token mismatch'
            ];
        }

        $skus = $request->get('skus');
        $violationIds = [];
        $violationSkus = [];

        foreach ($skus as $sku) {
            $id = $this->getProductIdFromSku($sku);
            $violationIds[] = $id;
        }
        if (count($violationIds)) {
            foreach (array_chunk($violationIds, 1000) as $partViolationIds) {
                DB::table('product')
                    ->whereIn('id', $partViolationIds)
                    ->update([
                        'is_violation' => 1,
                        'updated_at' => date('Y-m-d H:i:s')
                    ]);
            }
            $logData = [];
            foreach ($violationIds as $id) {
                $logData[] = [
                    'target_type' => 'VIOLATION_FROM_FILE',
                    'event_type' => 'UPDATE_STATUS',
                    'target_id' => $id,
                    'data' => json_encode(['is_violation' => 1]),
                    'created_at' => date('Y-m-d H:i:s')
                ];
            } 
            $deleteUrl = route('ads::ads:merchant::delete',['skip_ads' => 'on','updated_at_from' => date("Y-m-d H:i:s",strtotime('-5 minutes'))]);
            $this->triggerAsyncRequest($deleteUrl);

            foreach (array_chunk($logData, 500) as $partData) {
                DB::table('log')->insert($partData);
            }
        }

        return [
            'status' => 'successful',
            'violationIds' => $violationIds,
            'violationSkus' => $violationSkus
        ];
    }
    protected function getProductIdFromSku($sku){
        $retVal = 0;
        preg_match('/^P(\d+)-/i',$sku,$matches);
        if (isset($matches[1])){
            $retVal = $matches[1];
        }else{
            $product = DB::table('merchant_product')->where('sku',$sku)->first(['product_id']);
            if (!empty($product->product_id)){
                $retVal = $product->product_id;
            }
        }
        return $retVal;
    }
}
