<?php

namespace Modules\Trademarks\Controllers;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Maatwebsite\Excel\Facades\Excel;
use Illuminate\Support\Facades\Cache;
use Modules\Trademarks\Models\ProductModel;
use Modules\Trademarks\Controllers\Controller;
use Modules\Trademarks\Models\KeywordReplacementModel;

class KeywordReplacementController extends Controller
{
    public function index() {
        return view('trademarks::keyword-replacement.index');
    }

    public function rebuild(Request $request) {
        set_time_limit(10 * 3600);
        ini_set('memory_limit', '2048M');

        $retVal = [
            'status' => 'successful',
            'result' => []
        ];

        $query = ProductModel::query();

        if ($request->input('new_keyword')) {
            $this->newKeywordHour = $request->get('hour', 3);
        }

        if ($request->input('hour')) {
            $hour = $request->input('hour');
            $query->where('updated_at', '>=', date('Y-m-d H:i:s', strtotime('-' . $hour . ' hours')));
        }

        $step = $request->input('step', 10000);
        $fromId = $this->getFromId($request, $query);
        $toId = $this->getToId($request, $query);

        $query->whereNull('deleted_at');

        $query->whereIn('status', ['ACTIVE', 'INACTIVE']);

        $keywords = $this->getKeywordReplacement($request);

        if (!count($keywords)) {
            return [
                'status' => 'successful',
                'message' => 'empty keyword',
                'result' => []
            ];
        }

        while ($fromId <= $toId) {
            $stepToId = $fromId + $step;
            if ($toId < $stepToId) {
                $stepToId = $toId;
            }
            $cloneQuery = clone $query;
            $products = $cloneQuery->orderBy('id', 'asc')
                ->where('id', '>=', $fromId)
                ->where('id', '<=', $stepToId)
                ->get(['id', 'name']);
            foreach ($products as $product) {
                $isChange = false;
                foreach ($keywords as $keyword) {
                    $determier = trim($keyword->keyword);
                    $determier = str_replace('/', '\\/', $determier);
                    $regex = "/\\b" . $determier . "\\b/im";
                    if (preg_match($regex, $product->name)) {
                        $product->name = preg_replace($regex, $keyword->replace_keyword, $product->name);
                        $isChange = true;
                    }
                }
                if ($isChange) {
                    $product->save();
                    $retVal['result'][] = $product->id;
                }
            }
            $fromId += $step + 1;
        }

        return $retVal;
    }

    public function getFromId($request, $query, $orderField = 'created_at', $getField = 'id') {
        if ($request->input('minId')) {
            return $request->input('minId');
        }
        $cloneQuery = clone $query;

        $from = $cloneQuery->orderBy($orderField, 'asc')->first();
        if ($from) {
            return $from->{$getField};
        }

        return 0;
    }

    public function getToId($request, $query, $orderField = 'created_at', $getField = 'id') {
        if ($request->input('maxId')) {
            return $request->input('maxId');
        }
        $cloneQuery = clone $query;

        $to = $cloneQuery->orderBy($orderField, 'desc')->first();
        if ($to) {
            return $to->{$getField};
        }

        return 0;
    }

    public function getKeywordReplacement($request) {
        $query = KeywordReplacementModel::query();

        if ($request->input('new_keyword')) {
            $hour = $request->input('hour', 3);
            $query->where('updated_at', '>=', date('Y-m-d H:i:s', strtotime('-' . $hour . ' hours')));
        }

        return $query->orderBy('sorder', 'desc')->get();
    }
}
