<?php

namespace Modules\Trademarks\Controllers\Services;

use Exception;
use Illuminate\Http\Request;
use Modules\Trademarks\Models\Trademark;
use Modules\Trademarks\Repositories\LogRepository;
use Modules\Trademarks\Repositories\TrademarkRepository;
use DB;
use Illuminate\Support\Facades\Route;

class TrademarkController
{
    protected $logRepository;
    protected $trademarkRepository;

    public function __construct()
    {
        $this->logRepository = new LogRepository();
        $this->trademarkRepository = new TrademarkRepository();

    }

    public function store(Request $request)
    {   
        $retVal = [
            'status' => 'fail',
            'result' => [],
            'message' => ''
        ];
        $trademark = Trademark::create($request->all());
        if ($trademark) {
            $retVal['status'] = 'successful';
            $retVal['result'] = $trademark;
            $this->logRepository->keywordTrademark($trademark->id, 'CREAT_KEYWORD', $request->all());
        }
        return $retVal;
    }

    public function update(Request $request)
    {   
        $retVal = [
            'status' => 'fail',
            'result' => [],
            'message' => ''
        ];
        $routeParameters = Route::current()->parameters();
        $id = $routeParameters['id'];
        $trademark = Trademark::where('id', $id)->update($request->all());
        if ($trademark) {
            $retVal['status'] = 'successful';
            $retVal['result'] = $trademark;
            $this->logRepository->keywordTrademark($id, 'UPDATE_KEYWORD', $request->all());
        }
        return $retVal;
    }

    public function changeStatus(Request $request) {
        $retVal = [
            'status' => 'successful',
            'message' => ''
        ];
        $routeParameters = Route::current()->parameters();
        $id = $routeParameters['id'];
        if ($id && $request->has('status')) {
            Trademark::where('id', $id)
                ->update([
                    'status' => $request->get('status'),
                    'updated_at' => new \DateTime(),
                ]);
            $this->logRepository->keywordTrademark($id, 'CHANGE_STATUS', [
                'status' => $request->get('status'),
            ]);
        }

        return $retVal;
    }
}