<?php

namespace Modules\Trademarks\Controllers\Services;

use Illuminate\Http\Request;
use Modules\Trademarks\Models\SellerProductNTrademarkModel;
use Modules\Trademarks\Models\SellerTrademarkKeyword;
use Modules\Trademarks\Repositories\LogRepository;
use Modules\Trademarks\Repositories\TrademarkSellerRepository;
use Illuminate\Support\Facades\Route;

class TrademarkSellerController
{
    protected $logRepository;
    protected $trademarkSellerRepository;

    public function __construct()
    {
        $this->logRepository = new LogRepository();
        $this->trademarkSellerRepository = new TrademarkSellerRepository();

    }

    public function store(Request $request)
    {
        $retVal = [
            'status' => 'fail',
            'result' => [],
            'message' => ''
        ];
        $trademark = SellerTrademarkKeyword::create($request->all());
        if ($trademark) {
            $retVal['status'] = 'successful';
            $retVal['result'] = $trademark;
            $this->logRepository->keywordTrademark($trademark->id, 'CREAT_KEYWORD_SELLER', $request->all());
        }
        return $retVal;
    }

    public function update(Request $request)
    {
        $retVal = [
            'status' => 'fail',
            'result' => [],
            'message' => ''
        ];
        $routeParameters = Route::current()->parameters();
        $id = $routeParameters['id'];
        $trademark = SellerTrademarkKeyword::where('id', $id)->update($request->all());
        if ($trademark) {
            $retVal['status'] = 'successful';
            $retVal['result'] = $trademark;
            $this->logRepository->keywordTrademark($id, 'UPDATE_KEYWORD_SELLER', $request->all());
        }
        return $retVal;
    }

    public function changeStatus(Request $request)
    {
        $retVal = [
            'status' => 'successful',
            'message' => ''
        ];
        $routeParameters = Route::current()->parameters();
        $id = $routeParameters['id'];
        if ($id && $request->has('status')) {
            SellerTrademarkKeyword::where('id', $id)
                ->update([
                    'status' => $request->get('status'),
                    'updated_at' => new \DateTime(),
                ]);

            $this->logRepository->keywordTrademark($id, 'CHANGE_STATUS_SELLER', [
                'status' => $request->get('status'),
            ]);
        }

        return $retVal;
    }

    public function deleteTrademark($id)
    {
        set_time_limit(30 * 60);

        SellerTrademarkKeyword::query()
            ->where('id', $id)
            ->delete();
        SellerProductNTrademarkModel::query()
            ->where('trademark_id', $id)
            ->delete();

        return [
            'status' => 'successful'
        ];
    }
}