<?php

namespace Modules\Trademarks\Controllers;

use DB;
use Illuminate\Http\Request;
use Modules\Trademarks\Controllers\Controller;

class ViolationController extends Controller {
    public function checkViolation(Request $request) {
        set_time_limit(10 * 3600);
        ini_set('memory_limit', '2048M');
        $retVal = [
            'status' => 'successful',
            'result' => []
        ];

        $date = date('Y-m-d H:i:0', time() - $request->get('hour', 2) * 3600);
        $current = date('Y-m-d H:i:s', time());
        $isAll = false;
        if ($request->get('all')) {
            $isAll = true;
        }

        if ($request->has('keyword')) {
            $keyword = DB::table('trademarks')
                ->where('keyword', trim($request->get('keyword')))
                ->where('type', 'violation')
                ->where('status', 'ACTIVE')
                ->first();
            if ($keyword) {
                $violateKeywords = [$keyword];
            }
        } else if ($request->has('new_keyword')) {
            $violateKeywords = $this->getNewViolateKeywords($request);
        } else {
            $minMaxId = explode(',', $request->input('minMaxKeywordId', '0,0'));
            $violateKeywords = $this->getViolateKeywords($minMaxId[0], $minMaxId[1]);
        }

        foreach ($violateKeywords as $keyword) {
            $query = DB::table('product')
                ->where('is_violation', $request->get('is_violation', 0));
            $fromId = $this->getFromId($request, $query);
            $toId = $this->getToId($request, $query);
            if (!$isAll && !$request->has('from_id') && !$request->has('to_id')) {
                $query->where('updated_at', '>=', $date);
                $query->where('updated_at', '<=', $current);
            }
            $query->having('name', 'like', '%' . $keyword->keyword . '%');

            $step = $request->get('step', 10000);
            while($fromId <= $toId) {
                $stepToId = $fromId + $step;
                if ($toId < $stepToId) {
                    $stepToId = $toId;
                }
                $cloneQuery = clone $query;
                $cloneQuery
                    ->where('product.id', '>=', $fromId)
                    ->where('product.id', '<=', $stepToId)
                    ->select(\DB::raw("id, replace(replace(replace(replace(`name`, '-', ''), '.', ''), '_', ''), '+', '') as `name`, slug"));
                $products = $cloneQuery->get();
                $this->checkListProductViolate($products, $keyword);

                $fromId += $step + 1;
            }
        }

        return $retVal;
    }

    public function checkListProductViolate($products, $keyword) {
        $violateIds = [];
        $insertProductNViolateData = [];
        foreach ($products as $product) {
            $check = $this->checkNameIsViolate($product->name, $keyword->keyword);
            if (!$check) {
                $check = $this->checkNameIsViolate(str_replace('-', ' ', $product->slug), $keyword->keyword);
            }
            if ($check) {
                $retVal['result'][] = $product->id;
                $violateIds[] = $product->id;

                $insertProductNViolateData[] = [
                    'product_id' => $product->id,
                    'trademark_id' => $keyword->id,
                    'type' => 'violation',
                    'created_at' => date('Y-m-d H:i:s', time()),
                    'updated_at' => date('Y-m-d H:i:s', time()),
                ];
            }
        }

        $this->updateViolationProduct($violateIds);
        DB::table('product_n_trademark')
            ->insert($insertProductNViolateData);
    }

    public function recheckProductIsViolate(Request $request)
    {
        set_time_limit(10 * 3600);

        $retVal = [
            'status' => 'successful',
            'result' => []
        ];

        $query = DB::table('product_n_trademark')
            ->leftJoin('trademarks', 'product_n_trademark.trademark_id', 'trademarks.id')
            ->select('product_n_trademark.id', 'product_n_trademark.product_id')
            ->whereNull('trademarks.id');
        if ($request->get('trademark_id')) {
            $query->where('trademark_id', $request->get('trademark_id'));
        }
        $fromId = $this->getFromId($request, $query, 'product_n_trademark.id');
        $toId = $this->getToId($request, $query, 'product_n_trademark.id');
        $step = $request->get('step', 10000);
        while($fromId <= $toId) {
            $stepToId = $fromId + $step;
            if ($toId < $stepToId) {
                $stepToId = $toId;
            }

            $pnt = $query->where('product_n_trademark.id', '>=', $fromId)
                ->where('product_n_trademark.id', '<=', $stepToId)
                ->get();
            $pntIds = $pnt->pluck('id');
            $productIds = $pnt->pluck('product_id');
            $products = DB::table('product')
                ->where('is_violation', 1)
                ->whereNull('deleted_at')
                ->where('status', 'ACTIVE')
                ->whereIn('id', $productIds)
                ->select(\DB::raw("id, replace(replace(replace(replace(`name`, '-', ''), '.', ''), '_', ''), '+', '') as `name`, slug"))
                ->get();

            foreach ($products as $product) {
                if ($this->checkProductIsViolate($product)) {
                    $retVal['result'][] = $product->id;
                }
            }

            DB::table('product_n_trademark')->whereIn('id', $pntIds)->delete();

            $fromId += $step + 1;
        }

        return $retVal;
    }

    public function checkProductIsViolate($product) {
        $keywords = $this->getViolateKeywords();
        $isViolate = 0;
        foreach ($keywords as $keyword) {
            $check = $this->checkNameIsViolate($product->name, $keyword->keyword);
            if (!$check) {
                $check = $this->checkNameIsViolate(str_replace('-', ' ', $product->slug), $keyword->keyword);
            }
            if ($check) {
                $isViolate = 1;
                if (!DB::table('product_n_trademark')->where('product_id', $product->id)->where('trademark_id', $keyword->id)->exists()) {
                    DB::table('product_n_trademark')->insert([
                        'product_id' => $product->id,
                        'trademark_id' => $keyword->id,
                        'type' => 'violation',
                        'created_at' => date('Y-m-d H:i:s', time()),
                        'updated_at' => date('Y-m-d H:i:s', time()),
                    ]);
                }
            } else {
                DB::table('product_n_trademark')->where('product_id', $product->id)->where('trademark_id', $keyword->id)->delete();
            }
        }

        DB::table('product')
            ->where('id', $product->id)
            ->update([
                'is_violation' => $isViolate,
                'updated_at' => date('Y-m-d H:i:s', time())
            ]);

        return $isViolate;
    }

    public function checkNameIsViolate($name, $keyword) {
        $check = $this->isViolate($name, $keyword);
        if (!$check) {
            $name = preg_replace("/[^A-Za-z ]/", ' ', $name);
            $check = $this->isViolate($name, $keyword);
        }

        if (!$check) {
            $name = str_replace(' and ', ' ', $name);
            $check = $this->isViolate($name, $keyword);
        }
        if (!$check) {
            $originalName = $name;
            $name = preg_replace("/[^A-Za-z ]/", ' ', $name);
            $name = trim(preg_replace('/\s\s+/', ' ', str_replace("\n", " ", $name)));
            $check = $this->isViolate($name, $keyword);
            if (!$check) {
                $name = preg_replace("/[^A-Za-z ]/", '', $originalName);
                $check = $this->isViolate($name, $keyword);
            }
        }
        return $check;
    }

    public function getFromId($request, $query, $column = 'product.id') {
        if ($request->has('from_id')) {
            return $request->get('from_id');
        }
        $cloneQuery = clone $query;
        $from = $cloneQuery->orderBy($column, 'asc')->first();
        if ($from) {
            return $from->id;
        }

        return 0;
    }

    public function getToId($request, $query, $column = 'product.id') {
        if ($request->has('to_id')) {
            return $request->get('to_id');
        }
        $cloneQuery = clone $query;
        $to = $cloneQuery->orderBy($column, 'desc')->first();
        if ($to) {
            return $to->id;
        }

        return 0;
    }

    public function getNewViolateKeywords($request) {
        $violateKeywords = [];
        $date = date('Y-m-d H:i:0', time() - $request->get('hour', 2) * 3600);
        $current = date('Y-m-d H:i:s', time());
        $keywords = DB::table('trademarks')
            ->where('type', 'violation')
            ->where('status', 'ACTIVE')
            ->where('updated_at', '>=', $date)
            ->where('updated_at', '<=', $current)
            ->get(['id', 'keyword', 'type']);
        foreach ($keywords as $value) {
            $value->keyword = strtolower(trim($value->keyword));
            $violateKeywords[] = $value;
        }

        return $violateKeywords;
    }

    public function getViolateKeywords($minId = null, $maxId = null) {
        $violateKeywords = [];
        $query = DB::table('trademarks')
            ->where('type', 'violation'); 
        if ($minId && $maxId) {
            $query->where('id', '>=', $minId)
                ->where('id', '<=', $maxId);
        }
        $keywords = $query->get(['id', 'keyword']);
        foreach ($keywords as $value) {
            $value->keyword = strtolower(trim($value->keyword));
            $violateKeywords[] = $value;
        }

        return $violateKeywords;
    }

    public function isViolate($name, $keyword) {
        $retVal = false;
        $name = strtolower(trim($name));
        if (
            preg_match("/\b" . $keyword . "\b/i", $name) ||
            preg_match(sprintf("/^%s\s|\s%s\s|\s%s$/", $keyword, $keyword, $keyword), $name) ||
            preg_match(sprintf("/^%ss\s|\s%ss\s|\s%ss$/", $keyword, $keyword, $keyword), $name) ||
            preg_match(sprintf("/^%ses\s|\\s%ses\s|\s%ses$/", $keyword, $keyword, $keyword), $name) ||
            $name == $keyword 
        ) {
            $retVal = true;
        }

        return $retVal;
    }

    public function getViolationTag($request) {
        $retVal = [];

        if ($request->has('keyword')) {
            $violateKeywords = [$request->get('keyword')];
        } else {
            $violateKeywords = $this->getViolateKeywords();
        }

        foreach($violateKeywords as $keyword) {
            $query = DB::table('tag')
                ->select(\DB::raw("id, replace(replace(replace(replace(`title`, '-', ''), '.', ''), '_', ''), '+', '') as `title`, slug"))
                ->having('title', 'like', '%' . $keyword . '%');
            $tags = $query->get();

            foreach($tags as $item) {
                $check = $this->checkNameIsViolate($item->title, $keyword);
                if (!$check) {
                    $check = $this->checkNameIsViolate(str_replace('-', ' ', $item->slug), $keyword);
                }
                if ($check) {
                    $retVal[] = $item->id;
                }
            }
        }

        return array_unique($retVal);
    }

    public function checkViolationTag(Request $request) {
        set_time_limit(10 * 3600);
        ini_set('memory_limit', '2048M');
        $retVal = [
            'status' => 'successful',
            'result' => []
        ];

        $date = date('Y-m-d H:i:0', time() - $request->get('hour', 2) * 3600);
        $current = date('Y-m-d H:i:s', time());
        $isAll = false;
        if ($request->get('all')) {
            $isAll = true;
        }

        $tagIds = $this->getViolationTag($request);
        $query = DB::table('product')
            ->join('tag_refer', 'tag_refer.refer_id', 'product.id')
            ->where('refer_type', 'PRODUCT')
            ->where('is_violation', 0)
            ->select('product.id');
        foreach ($tagIds as $tagId) {
            $cloneQuery = clone $query; 
            $cloneQuery->where('tag_id', $tagId);

            $fromId = $this->getFromId($request, $cloneQuery);
            $toId = $this->getToId($request, $cloneQuery);
            $step = $request->get('step', 10000);
            while($fromId <= $toId) {
                $productIds = $cloneQuery->where('product.id', '>=', $fromId)
                    ->where('product.id', '<', $toId + $step)
                    ->get(['product.id'])
                    ->pluck('id')
                    ->toArray();
                $retVal['result'] = array_merge($retVal['result'], $productIds);

                // $this->updateViolationProduct($productIds);
                
                $fromId += $step;
            }
        }

        $retVal['result'] = array_values(array_unique($retVal['result']));

        return $retVal;
    }

    public function updateViolationProduct($productIds, $isHide = false) {
        foreach (array_chunk($productIds, 500) as $ids) {
            $updateData = [
                'is_violation' => 1,
                'updated_at' => date('Y-m-d H:i:s', time())
            ];
            if ($isHide) {
                $updateData['status'] = 'PENDING';
            }
            DB::table('product')->whereIn('id', $ids)
                ->update($updateData);
            
            //Save product meta violation by keywords
            $data = [];
            foreach ($ids as $key => $id) {
                if (!DB::table('product_meta')->where('product_id', $id)->where('key', 'violation_by_keywords')->exists()) {
                    $data[] = [
                        "key" => "violation_by_keywords",
                        "value" => 1,
                        "product_id" => $id
                    ];
                }
            }
            if (count($data)) {
                DB::table('product_meta')->insert($data);
            }
        }
    }
}
