<?php

namespace Modules\Trademarks\Controllers;

use Exception;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Log;
use Modules\Trademarks\Controllers\Controller;
use Modules\Trademarks\Models\ProductNTrademarkModel;

class WarningOrderController extends HomeController
{
    public function buildWarning(Request $request) {
        set_time_limit(30 * 60);

        $orderItems = $this->getOrderItems($request);
        $productIds = array_unique($orderItems->pluck('product_id')->toArray());

        $warningCheck = $this->getWarningCheck($productIds);

        $warningData = [];

        foreach ($orderItems as $item) {
            if (isset($warningCheck[$item->product_id])) {
                if (!isset($warningData[$item->order_id])) {
                    $warningData[$item->order_id] = [];
                }

                $warningData[$item->order_id][$item->product_id] = 1; 
            }
        }

        $result = [];

        foreach ($warningData as $orderId => $data) {
            $saveValue = array_keys($data);
            $meta = DB::table('order_meta')->where('order_id', $orderId)->where('key', 'warning_products')->first();
            if ($meta) {
                $value = json_decode($meta->value, true);
                $saveValue = array_values(array_unique(array_merge($saveValue, $value)));
                DB::table('order_meta')->where('id', $meta->id)->update([
                    'value' => json_encode($saveValue),
                ]);
            } else {
                DB::table('order_meta')->insert([
                    [
                        'value' => json_encode($saveValue),
                        'order_id' => $orderId,
                        'key' => 'warning_products',
                    ],
                    [
                        'value' => 1,
                        'order_id' => $orderId,
                        'key' => 'has_warning_products',
                    ]
                ]);

                // $order = DB::table('order')->where('id', $orderId)->first(['id', 'note']);
                // if ($order) {
                //     DB::table('order')->where('id', $orderId)->update([
                //         'note' => $order->note . ' đơn hàng chứa sp có thể dính trademark',
                //         'updated_at' => date('Y-m-d H:i:s', time())
                //     ]);
                // }
            }
            $result[] = $orderId;
        }

        return [
            'status' => 'successful',
            'result' => $result
        ];
    }

    public function getOrderItems($request) {
        $minutes = $request->get('minutes', 15);
        $fromDate = date('Y-m-d H:i:00', time() - $minutes * 60);
        $toDate = date('Y-m-d H:i:59', time());

        return DB::table('order_item')->where('created_at', '>=', $fromDate)
            ->where('created_at', '<=', $toDate)
            ->get(['id', 'order_id', 'product_id']);
    }

    public function getWarningCheck($productIds) {
        $warningProducts = DB::table('product_n_trademark')->where('type', 'warning')->whereIn('product_id', $productIds)->get();

        $otherIds = array_diff($productIds, $warningProducts->pluck('product_id')->toArray());
        $productIstradeMarkIds = DB::table('product')->whereIn('id', $otherIds)->where('is_trademark', 1)->get(['id'])->pluck('id');

        $warningCheck = [];
        foreach ($warningProducts as $item) {
            $warningCheck[$item->product_id] = 1;
        }

        foreach ($productIstradeMarkIds as $id) {
            $warningCheck[$id] = 1;
        }

        return $warningCheck;
    }
}