<?php

namespace Modules\Trademarks\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Module;

class WordController extends Controller
{

    public function checkProductName (Request $request)
    {
        $minId = $request->get('min_id', 0);
        $maxId = $request->get('max_id', 1000);
        $query = DB::table('product')
            ->where('status', 'ACTIVE');
        $max = $minId;

        while ($max < $maxId) {
            $min = $max;
            $max += 1000;
            if ($max > $maxId) {
                $max = $maxId;
            }
            $cloneQuery = clone $query;
            $products = $cloneQuery
                ->where('id', '>=', $min)
                ->where('id', '<=', $max)
                ->get(['name', 'status', 'id']);
            $insertData = [];
            foreach ($products as $product) {

                if ($this->regexCheck($product->name, $matches)) {
                    $insertData[] = [
                        'target_id' => $product->id,
                        'event_type' => 'CHECK_SPELL_PRODUCT_NAME',
                        'data' => $product->name
                    ];
                }
            }
            DB::table('log')->insert($insertData);
        }
        return [
            'status' => 'successful',
            'result' => count($insertData)
        ];
    }

    public function regexCheck ($name, &$matches)
    {
        $name = strtolower($name);
        $name = str_replace('-', ' ', $name);
        $name = str_replace("&rsquo;", '', $name);
        $name = str_replace("'", '', $name);
        $name = str_replace("/", ' ', $name);
        $name = str_replace("&nbsp;", ' ', $name);
        $name = str_replace("&#39;", ' ', $name);
        $name = str_replace('´', '', $name);
        return preg_match('/\w+[^a-zA-Z0-9,_\s]+\w+/', $name, $matches);
    }
}
