<?php

namespace Modules\Trademarks\EventListeners;

use Illuminate\Support\Facades\DB;
use App\Utils\EventHelper;

class BulkHideProductListener extends HideProductListener
{
    public function listen($data)
    {
        if (!isset($data['event_locale']) || empty($data['data'])) {
            return;
        }
        $locale = $data['event_locale'];

        $productIds = $data['data']['ids'];
        if ($locale != env('APP_LOCALE')) {
            try {
                foreach ($productIds as $productId) {
                    $this->hideProduct($productId, $locale, $data);
                }
            } catch (\Exception $ex) {
                \Log::info('BulkHideProductListener ERROR', [$ex->getMessage() . ' Line: ' . $ex->getLine() . ' File: ' . $ex->getFile(), $data['data']]);
            }
        }
    }
}