<?php

namespace Modules\Trademarks\EventListeners;

use Illuminate\Support\Facades\DB;
use App\Utils\EventHelper;

class BulkViolationProductListener extends ViolationProductListener
{
    public function listen($data)
    {
        if (!isset($data['event_locale']) || empty($data['data'])) {
            return;
        }
        $locale = $data['event_locale'];

        $productIds = $data['data']['ids'];
        if ($locale != env('APP_LOCALE')) {
            foreach ($productIds as $productId) {
                $this->hideProduct($productId, $locale, $data);
            }
        }
    }
}