<?php

namespace Modules\Trademarks\EventListeners;

use App\Utils\EventHelper;
use Illuminate\Support\Facades\DB;
use Modules\Trademarks\Service\HideProductService;
use Modules\Trademarks\EventListeners\BaseListener;

class HideProductByIdsListener extends BaseListener
{
    private $hideProductService;
    public function __construct(HideProductService $hideProductService)
    {
        $this->hideProductService = $hideProductService;
    }

    
    public function listen($data)
    {
        if (empty($data['data'])) {
            return;
        }
        if (!empty($data['event_options']['event_actor_email'])) {
            $user = DB::table('users')
                ->where('email', $data['event_options']['event_actor_email'])
                ->whereIn('role', ['STAFF', 'ADMIN'])
                ->where('status', 'ACTIVE')
                ->first(['id', 'email']);
    
            if (!$user) {
                \Log::error('HideProductByIdsListener User not found', $data);
            }
    
            $result = $this->hideProductService->hideProductByIds($user, $data['data']);
            \Log::error('HideProductByIdsListener $result', $result);
        }

        
    }
}