<?php

namespace Modules\Trademarks\EventListeners;

use Illuminate\Support\Facades\DB;
use App\Utils\EventHelper;

class ViolationProductListener extends BaseListener
{
    public function listen($data)
    {
        if (!isset($data['event_locale']) || empty($data['data'])) {
            return;
        }
        $locale = $data['event_locale'];

        $productId = $data['data']['id'];
        if ($locale != env('APP_LOCALE')) {
            $this->hideProduct($productId, $locale, $data);
        }
    }

    public function hideProduct($productId, $locale, $data) {
        $source = isset($data['event_source']) ? $data['event_source'] : strtolower(env('APP_NAME', 'printerval'));

        $originals = DB::table('original_product')->where('original_product_id', $productId)->where('source', $source . '-' . $locale)->get();
        foreach ($originals as $original) {
            if (DB::table('product')->where('id', $original->product_id)->where('is_violation', 1)->whereNull('deleted_at')->exists()) {
                continue;
            }
            $updateData =  [
                'is_violation' => 1,
                'updated_at' => date('Y-m-d H:i:s', time())
            ];
            DB::table('product')->where('id', $original->product_id)->update($updateData);

            $updateData['reason_to_violate'] = 'from event';
            $logData = $this->getLogData($original->product_id, $updateData);
            $this->writeLog($logData);
            EventHelper::pushEvent('productIsViolation', ['id' => $original->product_id]);
        }
    }

    public function getLogData($productId, $updateData) {
        return [
            'actor_email' => '',
            'target_type' => 'PRODUCT',
            'target_id' => $productId,
            'event_type' => 'UPDATE',
            'data' => json_encode($updateData),
            'created_at' => date('Y-m-d H:i:s', time())
        ];
    }
}