<?php

namespace Modules\Trademarks\Models;

use Illuminate\Database\Eloquent\Model;

class ProductModel extends Model
{
    protected $table = 'product';

    protected $fillable = [
        'sku',
        'barcode',
        'name',
        'slug',
        'image_url',
        'price',
        'high_price',
        'add_shipping_fee',
        'weight',
        'status',
        'description',
        'content',
        'note',
        'inventory',
        'brand_id',
        'status_out_stock',
        'pod_parent_id',
        'created_at',
        'updated_at',
        'trademarks',
        'is_trademark'
    ];

    public function productSkus()
    {
        return $this->hasMany(ProductSkuModel::class, 'product_id', 'id');
    }
}
