<?php

namespace Modules\Trademarks\Models;

use Illuminate\Database\Eloquent\Model;

class SellerProductNTrademarkModel extends Model
{
    protected $table = 'seller_product_n_trademark';

    protected $primaryKey = 'id';

    protected $fillable = [
        'product_id', 'trademark_id', 'type', 'reason', 'note', 'actor_id', 'hide_by', 'created_at', 'updated_at'
    ];

    protected $timestamp = true;

    public function product()
    {
        return $this->belongsTo(ProductModel::class, 'product_id', 'id');
    }

    public function trademark()
    {
        return $this->belongsTo(Trademark::class, 'trademark_id', 'id');
    }

    public function actor()
    {
        return $this->belongsTo(UserModel::class, 'actor_id', 'id');
    }
}