<?php

namespace Modules\Trademarks\Repositories;

use Illuminate\Support\Facades\Auth;
use Modules\Trademarks\Models\Log;

class LogRepository
{
    protected $model;

    public function __construct()
    {
        $this->model = new Log();
    }

    public function keywordTrademark($trademarkId, $event, $data)
    {
        $this->model
            ->insert([
                'actor_email' => Auth::user() ? Auth::user()->email : 'System',
                'target_type' => 'TRADEMARK_KEYWORD',
                'event_type' => $event,
                'target_id' => $trademarkId,
                'data' => json_encode($data),
                'created_at' => date('Y-m-d H:i:s')
            ]);
    }

    public function logTrademarkProduct($productId, $type, $data) {
        $this->model
            ->insert([
                'actor_email' => Auth::user() ? Auth::user()->email : 'System',
                'target_type' => 'PRODUCT_' . strtoupper($type),
                'event_type' => 'UPDATE_STATUS',
                'target_id' => $productId,
                'data' => $data,
                'created_at' => date('Y-m-d H:i:s')
            ]);
    }
}
