system.controller("AdsViolationKeywords", AdsViolationKeywords);

function AdsViolationKeywords($scope, $http, $rootScope) {
    this.__proto__ = new PaginationController($scope, $http, $rootScope);

    $scope.data = [];
    $scope.newKeyword = "";
    $scope.keywords = [];
    $scope.keyword = "";
    const init = () => {
        getKeywords();
    };

    const getKeywords = () => {
        $http
            .get(baseApiUrl + "/violation_keyword?page_size=-1")
            .then((res) => {
                if (res.data.status === "successful" && res.data.result.length > 0) {
                    console.log(res.data.result);
                    $scope.data = res.data.result;
                }
            });
    };
    $scope.addKeyword = () => {
        if (!$scope.newKeyword) {
            toastr.error("Keyword trống");
            return;
        }
        $http
            .post(baseApiUrl + "/violation_keyword", {
                keyword: $scope.newKeyword,
            })
            .then((res) => {
                if (res.data.status === "successful") {
                    $scope.$applyAsync(() => {
                        toastr.success("Thêm keyword thành công");
                        $scope.data.push(res.data.result);
                        $scope.newKeyword = "";
                    });
                } else {
                    toastr.error("An error occurred!");
                }
            })
            .catch(() => {
                toastr.error("An error occurred!");
            });
    };

    $scope.removeKeyword = (keyword) => {
        $http
            .delete(baseApiUrl + "/violation_keyword/" + keyword.id)
            .then((res) => {
                if (res.data.status === "successful") {
                    $scope.$applyAsync(() => {
                        $scope.data = $scope.data.filter(
                            (key) => key.id !== keyword.id
                        );
                        toastr.success("Xóa keyword thành công");
                        $scope.newKeyword = "";
                    });
                } else {
                    toastr.error("An error occurred!");
                }
            })
            .catch(() => {
                toastr.error("An error occurred!");
            });
    };

    $scope.searchFilter = () => {
        $http
            .get(baseApiUrl + "/violation_keyword?page_size=-1&filters=keyword~" + $scope.keyword )
            .then((res) => {
                if (res.data.status === "successful") {
                    $scope.data = res.data.result;
                }
            });
    };

    $scope.importItems = function (items) {
        $http.post('/trademarks/import-violation', {
            items: items
        }).then(function (res) {
            if (res.data.status == 'successful') {
                window.location.reload();
            } else {
                toastr.error('Đã có lỗi xảy ra vui lòng liên hệ đội kỹ thuật');
            }
        }, function (error) {
            toastr.error('Đã có lỗi xảy ra vui lòng liên hệ đội kỹ thuật');
        })
    }

    $scope.loadFile = async function (files) {
        if (files && files.length) {
            $scope.file = files[0];
            var reader = new FileReader();
            let fileExt = getFileExtension($scope.file.name);
            if (fileExt == 'csv') {
                reader.readAsText($scope.file);
            } else if (fileExt == 'xls' || fileExt == 'xlsx') {
                reader.readAsBinaryString($scope.file);
            }
            reader.onload = await function(e) {
                var content = e.target.result;
                var items = processData(content, fileExt);
                $scope.importItems(items);
            };
            toastr.warning('Dữ liệu đang được import. Vui lòng chờ trong giây lát');
        }
    }

    function processData(content, fileExt) {
        let objects = [];
        try {
            if (fileExt == 'csv') {
                objects = $.csv.toObjects(content);
            } else if (fileExt == 'xls' || fileExt == 'xlsx') {
                let workbook = XLSX.read(content, {
                    type: 'binary'
                });
                workbook.SheetNames.forEach(sheet => {
                    let arrayObject = XLSX.utils.sheet_to_row_object_array(
                        workbook.Sheets[sheet]
                    );
                    objects = objects.concat(arrayObject);
                });
            }
        } catch (ex) {
            console.log(ex);
            $scope.showErrorModal('Không thể đọc được file.');
        }
        
        return objects;
    }

    function getFileExtension(filename)
    {
        var ext = /^.+\.([^.]+)$/.exec(filename);
        return ext == null ? "" : ext[1];
    }

    init();
}
