system.controller("CheckTrademarkController", CheckTrademarkController);

function CheckTrademarkController($scope, $http, $rootScope) {
    this.__proto__ = new BaseController($scope, $http, $rootScope);

    $scope.checkValue = trademarkCheckValue;
    $scope.checkFields = trademarkCheckFields.split(',');
    $scope.checkTrademarkResult = {};
    $scope.isCheckingTrademark = false;
    $scope.isEmty = false;

    $scope.$on('initialize', () => {
        $scope.checkTrademarkResult = {};
        $scope.isCheckingTrademark = false;
        $scope.isEmty = false;
    })

    $scope.checkTrademark = () => {
        $scope.checkTrademarkResult = {};
        $scope.isCheckingTrademark = true;
        let url = window.location.origin.replace('https://', 'https://direct.');
        let locale = typeof localePrefix != 'undefined' && localePrefix && localePrefix != 'us' ? `/${localePrefix}` : '';
        let data = {};
        for (let field of $scope.checkFields) {
            if ($scope[$scope.checkValue] && $scope[$scope.checkValue][field]) {
                data[field] = $scope[$scope.checkValue][field];
            }
        }
        if (Object.keys(data).length) {
            $http.post(url + locale + '/trademarks/test-trademark?ignore_localization=1', {
                value: data
            }).then(res => {
                $scope.isCheckingTrademark = false;
                if (res.data.status == 'successful') {
                    let result = res.data.result;
                    for (let key in result) {
                        for (let type in result[key]) {
                            if  (result[key][type].length) {
                                if (!$scope.checkTrademarkResult[key]) {
                                    $scope.checkTrademarkResult[key] = [];
                                }
                                $scope.checkTrademarkResult[key] = $scope.checkTrademarkResult[key].concat(result[key][type]);
                            }
                        }
                    }
                }
                $scope.isEmty = !Object.keys($scope.checkTrademarkResult).length;
            }, error => {
                $scope.isEmty = true;
                $scope.isCheckingTrademark = false;
            })
        } else {
            $scope.isCheckingTrademark = false;
        }
    }
}