system.controller(
    "HideProductByLinkController",
    HideProductByLinkController
);

function HideProductByLinkController($scope, $http, Upload) {
    this.__proto__ = new BaseController($scope, $http, Upload);
    $scope.productLinks = ``;
    $scope.isLoading = false;
    $scope.productIds = '';
    $scope.productBySellers = [];
    $scope.trademarkItems = [];
    $scope.config = {
        isHideSameDesign: false,
        selectedReason: 'other',
        selectedTrademarkItems: [],
        note: ''
    }

    $scope.reasons = [
        {title: 'Mail report ', value: 'mail'},
        {title: 'Ticket report ', value: 'ticket'},
        {title: 'Counterfeit', value: 'counterfeit'},
        {title: 'Dmca', value: 'dmca'},
        {title: 'Cloud', value: 'cloud'},
        {title: 'Other', value: 'other'},
    ];

    $scope.$watch('productLinks', (newValue) => {
        let rows = newValue.split(/\n+/gm);
        let productIds = [];
        for (let row of rows) {
            let productId = row.trim().split('?')[0].replace(/(.*-p|^p)(\d+).*/gmi, '$2').trim();
            if (productId) {
                productIds.push(productId);
            }
        }

        $scope.productIds  = productIds.join(',');
        console.log($scope.productIds );
    });

    $scope.initialize = () => {
        $scope.findTrademark();
    }


    $scope.buildProductUrl = (product) => {
        return window.location.origin + ((typeof localPrefix == 'undefined' || localPrefix == 'us' ) ? '/' : `/${localPrefix}`) + product.slug + '-p' + product.id;
    }

    $scope.hideProductsDelay = () => {
        $scope.isLoading = true;
        $scope.productBySellers = [];
        let url = restQUrl;
        if (typeof localPrefix != 'undefined' && localPrefix) {
            url = restQUrl + `/${localPrefix}`;
        }
        url += `/listen-event?ignore_localization=1`;

        let data = {
            event_name: 'hideProductByIds',
            event_options: {
                event_actor_email: typeof user != 'undefined' ? user.email : ''
            },
            data: {
                product_ids: $scope.productIds,
                hide_same_design: $scope.config.isHideSameDesign,
                trademark_ids: $scope.config.selectedTrademarkItems,
                note: $scope.config.note,
                reason: $scope.config.selectedReason ? $scope.config.selectedReason : 'by-id',
            }
        };

        let promises = [
            $http.post(`${url}&delay=${5 * 3600}`, data),
            $http.post(`${url}&delay=${20 * 3600}&priority=999999`, data)
        ];

        Promise.all(promises).then(res => {
            $scope.$apply(function () {
                $scope.isLoading = false;
                $scope.productBySellers = [];
            })
            toastr.success("Sản phẩm sẽ được ẩn sau 5 tiếng");
        }).catch((e) => {
            $scope.$apply(function () {
                $scope.isLoading = false;
            })
            toastr.error("Đã có lỗi xảy ra. Vui lòng liên hệ đội kỹ thuật");
        });
    };

    $scope.hideProducts = () => {
        $scope.isLoading = true;
        $scope.productBySellers = [];
        $http
            .post("/trademarks/hide-product-by-ids", {
                product_ids: $scope.productIds ,
                hide_same_design: $scope.config.isHideSameDesign,
                trademark_ids: $scope.config.selectedTrademarkItems,
                note: $scope.config.note,
                reason: $scope.config.selectedReason ? $scope.config.selectedReason : 'by-id',
            })
            .then((res) => {
                if (res.data.status === 'successful') {
                    $scope.isLoading = false;
                    $scope.productBySellers = res.data.result;
                    toastr.success("Ẩn thành công");
                }
            })
            .catch((e) => {
                $scope.isLoading = false;
                toastr.error("Đã có lỗi xảy ra. Vui lòng liên hệ đội kỹ thuật");
            });
    };


    $scope.findTrademark = () => {
        $http.get($scope.buildUrl('/trademarks?filters=status=ACTIVE&sorts=-created_at&page_size=-1'))
            .then(res => {
                if (res.data.status == 'successful') {
                    $scope.trademarkItems = res.data.result;
                }
            })
    }

    $scope.markViolation = () => {
        $scope.isLoading = true;
        $scope.productBySellers = [];
        $http
            .post("/trademarks/mark-violation-product-by-ids", {
                product_ids: $scope.productIds ,
                hide_same_design: $scope.isHideSameDesign,
            })
            .then((res) => {
                if (res.data.status === 'successful') {
                    $scope.isLoading = false;
                    $scope.productBySellers = res.data.result;
                    toastr.success("Tích vi phạm thành công");
                }
            })
            .catch((e) => {
                $scope.isLoading = false;
                toastr.error("Đã có lỗi xảy ra. Vui lòng liên hệ đội kỹ thuật");
            });
    };

    $scope.initialize();
}
