system.controller("TrademarkProductSellerController", TrademarkProductSellerController);

function TrademarkProductSellerController($scope, $http, $rootScope, $interval, $window, Upload) {
    this.__proto__ = new PaginationController($scope, $http, $rootScope, Upload);

    $scope.filters = {
        search: "",
        trademark_id: undefined,
        actor_id: undefined
    };

    $scope.reasons = [
        {title: 'Mail report ', value: 'mail'},
        {title: 'Ticket report ', value: 'ticket'},
        {title: 'Counterfeit', value: 'counterfeit'},
        {title: 'Dmca', value: 'dmca'},
        {title: 'Cloud', value: 'cloud'},
        {title: 'Auto', value: 'auto'},
    ]

    $scope.staffs = staffs;
    $scope.sellers = sellers;

    $scope.isSelectedAll = false;
    $scope.selectedProductLength = 0;
    $scope.loading = false;

    $scope.initialize = () => {
        $scope.find();

        $scope.findTrademark();
    }

    $scope.findTrademark = () => {
        $http.get($scope.buildUrl('/seller_trademarks_keyword?filters=status=ACTIVE&sorts=-created_at&page_size=-1'))
            .then(res => {
                if (res.data.status == 'successful') {
                    $scope.trademarkItems = res.data.result;
                }
            })
    }

    $scope.reset = () => {
        $scope.meta.page_id = 0;
        $scope.filters = {
            search: "",
            trademark_id: undefined,
            actor_id: undefined
        };
        $scope.find(true);
    }

    $scope.buildFilterUrl = (url) => {
        let filters = [];
        if ($scope.filters.dateFrom) {
            filters.push("date_from=" + $scope.vietnameseTimeToSQLTime($scope.filters.dateFrom) + " 00:00:00");
        }

        if ($scope.filters.dateTo) {
            filters.push("date_to=" + $scope.vietnameseTimeToSQLTime($scope.filters.dateTo) + " 23:59:59");
        }

        if ($scope.filters.updateFrom) {
            filters.push("update_from=" + $scope.vietnameseTimeToSQLTime($scope.filters.updateFrom) + " 00:00:00");
        }

        if ($scope.filters.updateTo) {
            filters.push("update_to=" + $scope.vietnameseTimeToSQLTime($scope.filters.updateTo) + " 23:59:59");
        }

        let keys = ['search', 'type', 'trademark_id', 'actor_id', 'product_actor_id', 'product_status', 'reason'];
        for (let key of keys) {
            if ($scope.filters[key]) {
                filters.push(`${key}=${$scope.filters[key]}`);
            }
        }

        return url + (url.indexOf('?') > 0 ? '&' : '?') + filters.join('&');
    }

    $scope.find = (refresh = false) => {
        $scope.resetSelectedProducts();

        if (refresh) {
            $scope.meta.page_id = 0;
        }

        $scope.products = [];
        $scope.loading = true;

        $http.get($scope.buildFilterUrl(`/trademarks-seller/trademark-product/find?page_id=${$scope.meta.page_id}`))
            .then(res => {
                if (res.data.status == 'successful') {
                    $scope.products = res.data.result;
                    for (let key in $scope.products) {
                        $scope.products[key].url = $scope.getProductUrl($scope.products[key]);
                    }
                    $scope.meta = res.data.meta;
                    if (res.data.result.length < $scope.meta.page_size) {
                        $scope.meta.page_count = $scope.meta.page_id + 1;
                        $scope.meta.has_next = false;
                    } else {
                        $scope.meta.page_count = $scope.meta.page_id + 5;
                    }
                    $scope.meta.hide_page_count = 1;
                }
                $scope.loading = false;
            }, err => {
                console.log(err);
                $scope.loading = false;
            })
    }

    $scope.getProductUrl = (product) => {
        return `${localePrefix && localePrefix != defaultLocale ? `/${localePrefix}/` : '/'}${product.slug}-p${product.id}`;
    }

    $scope.addSelectedProducts = function (index) {
        $scope.products[index].selected = !$scope.products[index].selected;
        if ($scope.products[index].selected) {
            $scope.selectedProductLength++
        } else {
            $scope.selectedProductLength--;
        }
        $scope.isSelectedAll = $scope.checkSelectedAll()
    };

    $scope.resetOrCheckAll = function () {
        for (let index in $scope.products) {
            $scope.products[index].selected = $scope.isSelectedAll;
        }
        $scope.selectedProductLength = $scope.isSelectedAll ? $scope.products.length : 0;
    }

    $scope.resetSelectedProducts = () => {
        $scope.isSelectedAll = 0;
        $scope.selectedProductLength = 0;
    }

    $scope.checkSelectedAll = function () {
        return !$scope.products.find(item => !item.selected);
    }

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.find();
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.find();
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.find();
        }
    };

    $scope.sendMessage = (item = null) => {
        $scope.callConfirmModal({
            title: 'Gửi cảnh báo vi phạm',
            text: "gửi cảnh báo vi phạm"
        }, function () {
            let productIds = [];
            if (item) {
                productIds.push(item.product_id);
            } else {
                productIds = $scope.products.filter(item => item.selected).map(item => item.product_id);
            }
            let url = $scope.buildUrl('/seller/send-email-warning-trademarks');

            $http
                .post(url, {
                    product_ids: productIds.join(','),
                })
                .then((res) => {
                    if (res.data.status === 'successful') {
                        $scope.isLoading = false;
                        toastr.success("Gửi cảnh báo thành công");
                    }
                })
                .catch((e) => {
                    $scope.isLoading = false;
                    toastr.error("Đã có lỗi xảy ra. Vui lòng liên hệ đội kỹ thuật");
                });
        });
    }

    $scope.export = function () {
        toastr.warning('Vui lòng đợi trong vài phút. Dữ liệu sẽ được gửi vào email của bạn.')
        let url = $scope.buildFilterUrl(`/trademarks-seller/trademark-product/find`);
        if (localePrefix && localePrefix != defaultLocale) {
            url = `${localePrefix}/` + url
        }
        url = window.location.origin + url;
        $http.post('/trademarks-seller/trademark-product/export', {
            filter_url: url
        })
    }

    $scope.initialize();
}