system.controller("WarningProductController", WarningProductController);

function WarningProductController($scope, $http, $rootScope, $interval, $window, Upload) {
    this.__proto__ = new PaginationController($scope, $http, $rootScope, Upload);

    $scope.filters = {
        search: "",
        trademark_id: undefined,
        type: "warning",
        actor_id: undefined,
    };

    $scope.types = [
        {
            key: "warning",
            name: "Chờ duyệt"
        },
        {
            key: "not-warning",
            name: "Đã bỏ cảnh báo"
        },
        {
            key: "hided",
            name: "Đã ẩn sp"
        }
    ]
    $scope.staffs = staffs;

    $scope.isSelectedAll = false;
    $scope.selectedProductLength = 0;
    $scope.loading = false;

    $scope.initialize = () => {
        $scope.filters.dateFrom = $scope.formatFilterDate((new Date((new Date()).getTime() - 7 * 86400 * 1000)));
        $scope.filters.dateTo = $scope.formatFilterDate(new Date());
        $scope.find();

        $scope.findTrademark();
    }

    $scope.formatFilterDate = (date) => {
        return date.toISOString().slice(0, 10).replace('T', ' ').split('-').reverse().join('/');
    }

    $scope.findTrademark = () => {
        $http.get($scope.buildUrl('/trademarks?filters=status=ACTIVE,type=warning&sorts=-created_at&page_size=-1'))
            .then(res => {
                if (res.data.status == 'successful') {
                    $scope.trademarkItems = res.data.result;
                }
            })
    }

    $scope.reset = () => {
        $scope.meta.page_id = 0;
        $scope.filters = {
            search: "",
            trademark_id: undefined,
            type: "warning",
            actor_id: undefined,
            dateFrom: $scope.formatFilterDate((new Date((new Date()).getTime() - 7 * 86400 * 1000))),
            dateTo: $scope.formatFilterDate(new Date()),
        };
        $scope.find(true);
    }

    $scope.buildFilterUrl = (url) => {
        let filters = [];
        if (!$scope.filters.dateFrom) {
            $scope.filters.dateFrom = $scope.formatFilterDate(new Date((new Date()).getTime() - 7 * 86400 * 1000));
        }
        filters.push("date_from=" + $scope.vietnameseTimeToSQLTime($scope.filters.dateFrom) + " 00:00:00");

        if (!$scope.filters.dateTo) {
            $scope.filters.dateTo = $scope.formatFilterDate(new Date());
        }
        filters.push("date_to=" + $scope.vietnameseTimeToSQLTime($scope.filters.dateTo) + " 23:59:59");

        if ($scope.filters.updateFrom) {
            filters.push("update_from=" + $scope.vietnameseTimeToSQLTime($scope.filters.updateFrom) + " 00:00:00");
        }

        if ($scope.filters.updateTo) {
            filters.push("update_to=" + $scope.vietnameseTimeToSQLTime($scope.filters.updateTo) + " 23:59:59");
        }

        let keys = ['search', 'type', 'trademark_id', 'actor_id', 'product_actor_id', 'product_status'];
        for (let key of keys) {
            if ($scope.filters[key]) {
                filters.push(`${key}=${$scope.filters[key]}`);
            }
        }

        return url + (url.indexOf('?') > 0 ? '&' : '?') + filters.join('&');
    }

    $scope.find = (refresh = false) => {
        $scope.resetSelectedProducts();

        if (refresh) {
            $scope.meta.page_id = 0;
        }

        $scope.products = [];
        $scope.loading = true;

        $http.get($scope.buildFilterUrl(`/trademarks/warning-product/find?page_id=${$scope.meta.page_id}`))
            .then(res => {
                if (res.data.status == 'successful') {
                    $scope.products = res.data.result;
                    for (let key in $scope.products) {
                        $scope.products[key].url = $scope.getProductUrl($scope.products[key]);
                    }
                    $scope.meta = res.data.meta;
                    $scope.findTracking();
                }
                $scope.loading = false;
            }, err => {
                console.log(err);
                $scope.loading = false;
            })
    }

    $scope.getProductUrl = (product) => {
        return `${localePrefix && localePrefix != defaultLocale ? `/${localePrefix}/` : '/'}${product.slug}-p${product.id}`;
    }

    $scope.addSelectedProducts = function (index) {
        $scope.products[index].selected = !$scope.products[index].selected;
        if ($scope.products[index].selected) {
            $scope.selectedProductLength++
        } else {
            $scope.selectedProductLength--;
        }
        $scope.isSelectedAll = $scope.checkSelectedAll()
    };

    $scope.resetOrCheckAll = function () {
        for (let index in $scope.products) {
            $scope.products[index].selected = $scope.isSelectedAll;
        }
        $scope.selectedProductLength = $scope.isSelectedAll ? $scope.products.length : 0;
    }

    $scope.resetSelectedProducts = () => {
        $scope.isSelectedAll = 0;
        $scope.selectedProductLength = 0;
    }

    $scope.checkSelectedAll = function () {
        return !$scope.products.find(item => !item.selected);
    }

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.find();
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.find();
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.find();
        }
    };

    $scope.markTrademark = (item = null) => {
        $scope.callConfirmModal({
            title: 'Đánh dấu trademark',
            text: "đánh dấu trademark"
        }, function() {
            let productIds = [];
            let trademarkIds = [];
            if (item) {
                productIds.push(item.product_id);
                trademarkIds.push(item.trademark_id);
            } else {
                productIds = $scope.products.filter(item => item.selected).map(item => item.product_id);
                trademarkIds = $scope.products.filter(item => item.selected).map(item => item.trademark_id);
            }

            $http
                .post("/trademarks/hide-product-by-ids", {
                    product_ids: productIds.join(','),
                    hide_same_design: true,
                    trademark_ids: trademarkIds,
                    hide_by: "warning"
                })
                .then((res) => {
                    if (res.data.status === 'successful') {
                        $scope.isLoading = false;
                        toastr.success("Ẩn thành công");
                    }
                })
                .catch((e) => {
                    $scope.isLoading = false;
                    toastr.error("Đã có lỗi xảy ra. Vui lòng liên hệ đội kỹ thuật");
                });
        });
    }

    $scope.removeWarning = (item = null) => {
        $scope.callConfirmModal({
            title: 'Bỏ cảnh báo trademark',
            text: "bỏ cảnh báo trademark"
        }, function() {
            let productIds = [];
            let trademarkIds = [];
            if (item) {
                productIds.push(item.product_id);
                trademarkIds.push(item.trademark_id);
            } else {
                productIds = $scope.products.filter(item => item.selected).map(item => item.product_id);
                trademarkIds = $scope.products.filter(item => item.selected).map(item => item.trademark_id);
            }

            $http
                .post("/trademarks/warning-product/hide-warning", {
                    product_ids: productIds.join(','),
                    hide_same_design: true,
                    trademark_ids: trademarkIds,
                })
                .then((res) => {
                    if (res.data.status === 'successful') {
                        $scope.isLoading = false;
                        toastr.success("Ẩn thành công");
                    }
                })
                .catch((e) => {
                    $scope.isLoading = false;
                    toastr.error("Đã có lỗi xảy ra. Vui lòng liên hệ đội kỹ thuật");
                });
        });
    }

    $scope.findTracking = () => {
        $http.get('/module/ads/product-performance?product_ids=' + $scope.products.map(item => item.id).join(','))
            .then(res => {
                let itemByProductId = {}
                for (let item of res.data.result) {
                    itemByProductId[item.product_id] = item;
                }

                for (let key in $scope.products) {
                    let product = $scope.products[key];
                    if (itemByProductId[product.id]) {
                        $scope.products[key].performance = itemByProductId[product.id];
                    }
                }
            });

        $http.get($scope.buildUrl(`/merchant_product?filters=product_id={${$scope.products.map(item => item.id).join(';')}}&fields=product_id`))
            .then(res => {
                let itemByProductId = {}
                for (let item of res.data.result) {
                    itemByProductId[item.product_id] = 1;
                }

                for (let key in $scope.products) {
                    let product = $scope.products[key];
                    if (itemByProductId[product.id]) {
                        $scope.products[key].fed = 1;
                    }
                }
            });
    }

    $scope.initialize();
}