system.controller("WrongLanguageController", WrongLanguageController);

function WrongLanguageController($scope, $http, $rootScope, $interval, $window, Upload) {
    this.__proto__ = new PaginationController($scope, $http, $rootScope, Upload);

    $scope.filters = {
        search: "",
        status: "ACTIVE",
        actor_id: undefined
    };

    $scope.statuses = [
        {
            key: "ACTIVE",
            name: "Cảnh báo"
        },
        {
            key: "PENDING",
            name: "Đã bỏ cảnh báo"
        },
    ];
    
    $scope.staffs = staffs;

    $scope.isSelectedAll = false;
    $scope.selectedProductLength = 0;
    $scope.loading = false;

    $scope.initialize = () => {
        $scope.find();
    }

    $scope.reset = () => {
        $scope.meta.page_id = 0;
        $scope.filters = {
            search: "",
            status: "ACTIVE",
            actor_id: undefined
        };
        $scope.find(true);
    }

    $scope.buildFilterUrl = (url) => {
        let filters = [];
        if ($scope.filters.dateFrom) {
            filters.push("date_from=" + $scope.vietnameseTimeToSQLTime($scope.filters.dateFrom) + " 00:00:00");
        }

        if ($scope.filters.dateTo) {
            filters.push("date_to=" + $scope.vietnameseTimeToSQLTime($scope.filters.dateTo) + " 23:59:59");
        }

        let keys = ['search', 'actor_id', 'product_actor_id', 'status'];
        for (let key of keys) {
            if ($scope.filters[key]) {
                filters.push(`${key}=${$scope.filters[key]}`);
            }
        }

        return url + (url.indexOf('?') > 0 ? '&' : '?') + filters.join('&');
    }

    $scope.find = (refresh = false) => {
        $scope.resetSelectedProducts();

        if (refresh) {
            $scope.meta.page_id = 0;
        }

        $scope.products = [];
        $scope.loading = true;

        $http.get($scope.buildFilterUrl(`/trademarks/wrong-language/find?page_id=${$scope.meta.page_id}`))
            .then(res => {
                if (res.data.status == 'successful') {
                    $scope.products = res.data.result;
                    for (let key in $scope.products) {
                        $scope.products[key].url = $scope.getProductUrl($scope.products[key]);
                    }
                    $scope.meta = res.data.meta;
                }
                $scope.loading = false;
            }, err => {
                console.log(err);
                $scope.loading = false;
            })
    }

    $scope.getProductUrl = (product) => {
        return `${localePrefix && localePrefix != defaultLocale ? `/${localePrefix}/` : '/'}${product.slug}-p${product.id}`;
    }

    $scope.addSelectedProducts = function (index) {
        $scope.products[index].selected = !$scope.products[index].selected;
        if ($scope.products[index].selected) {
            $scope.selectedProductLength++
        } else {
            $scope.selectedProductLength--;
        }
        $scope.isSelectedAll = $scope.checkSelectedAll()
    };

    $scope.resetOrCheckAll = function () {
        for (let index in $scope.products) {
            $scope.products[index].selected = $scope.isSelectedAll;
        }
        $scope.selectedProductLength = $scope.isSelectedAll ? $scope.products.length : 0;
    }

    $scope.resetSelectedProducts = () => {
        $scope.isSelectedAll = 0;
        $scope.selectedProductLength = 0;
    }

    $scope.checkSelectedAll = function () {
        return !$scope.products.find(item => !item.selected);
    }

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.find();
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.find();
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.find();
        }
    };

    $scope.check = function (product = null) {
        let checkIds = [];
        if (product) {
            checkIds.push(product.product_id);
        } else {
            checkIds = $scope.products.filter(item => item.selected).map(item => item.product_id);
        }
        $http.get($scope.buildUrl('/language/build-warning?ids=' + checkIds.join(',')))
            .then(res => {
                if (res.data.status == 'successful' && res.data.service_result && res.data.service_result.message == 'Successful') {
                    let result = res.data.service_result.result;
                    console.log('result', result);
                    for (let key in $scope.products) {
                        if (result[$scope.products[key].product_id]) {
                            $scope.products[key].other_language = result[$scope.products[key].product_id].join(',');
                        } else {
                            $scope.products[key].other_language = '';
                        }
                        $scope.products[key].is_dirty = true;
                    }
                }
            })
    }

    $scope.removeWarning = (item = null) => {
        $scope.callConfirmModal({
            title: 'Bỏ cảnh báo sai ngôn ngữ',
            text: "bỏ cảnh báo sai ngôn ngữ"
        }, function() {
            let productIds = [];
            if (item) {
                productIds.push(item.product_id);
            } else {
                productIds = $scope.products.filter(item => item.selected).map(item => item.product_id);
            }

            $http.post("/trademarks/wrong-language/hide-warning", {
                    product_ids: productIds.join(','),
                    // hide_same_design: true,
                })
                .then((res) => {
                    if (res.data.status === 'successful') {
                        $scope.isLoading = false;
                        toastr.success("Ẩn thành công");
                    }
                })
                .catch((e) => {
                    $scope.isLoading = false;
                    toastr.error("Đã có lỗi xảy ra. Vui lòng liên hệ đội kỹ thuật");
                });
        });
    }


    $scope.initialize();
}