system.controller("ImportViolationProductController", ImportViolationProductController);

function ImportViolationProductController($scope, $http, $rootScope, $interval, $window, Upload) {
    this.__proto__ = new BaseController($scope, $http, $rootScope, Upload);
    
    $scope.types = {
        policy_violation: 'Vi phạm chính sách',
        extraneous: 'Từ bị cấm'
    };
    $scope.isLoading = false;

    $scope.importData = {
        file: {
            name: '',
            url: ''
        },
        type: 'policy_violation'
    }

    $scope.reset = function () {
        $scope.importData = {
            file: {
                name: '',
                url: ''
            },
            type: 'policy_violation'
        }
    }

    $scope.onSelectFile = async function ($files) {
        if ($files && $files.length) {
            $scope.$applyAsync(async function () {
                $scope.importData.file.name = $files[0].name;
                let url = await $scope.uploadFile($files[0], 'violation');
                $scope.importData.file.url = url;
            })


        }
    }

    $scope.import = function () {
        if (!$scope.importData.file.url) {
            toastr.error('Vui lòng chọn file');
            return;
        }
        $scope.isLoading = true;
        $http({
            url: '/trademarks/import-violation-product', 
            method: 'POST',
            data: $scope.importData,
            timeout: 10000
        })
            .then(function (response) {
                if (response.data.status == 'successful') {
                    toastr.success('Nhập sp vi phạm thành công');
                    $('#import-modal').modal('toggle');
                    $scope.reset();
                } else {
                    toastr.error(response.data.message);
                }
                $scope.isLoading = false;
            }).catch(error => {
                if (error.status >= 400) {
                    toastr.error('Đã có lỗi xảy ra');
                } else if (error.xhrStatus == "timeout") {
                    toastr.warning('Hệ thống đang nhập sp vi phạm');
                    $('#import-modal').modal('toggle');
                    $scope.reset();
                }
                $scope.isLoading = false;
            })
    }

    $scope.uploadFile = function (file, type) {
        if (typeof file == 'array') {
            file = file[0];
        }
        return new Promise(function(resolve, reject) {
            Upload.upload({
                url: googleCloudStorageBucket + '/upload',
                data: {upload: file, type: type}
            }).then(function (resp) {
                if (resp.data.status == 'successful') {
                    let upload = resp.data.upload[0];
                    resolve(upload);
                } else {
                    reject(0);
                }
            }, function (resp) {
                reject(0);
            });
        });
    }
}