system.controller("TrademarksController", TrademarksController);

function TrademarksController($scope, $http, $rootScope, $interval, $window, Upload) {
    this.__proto__ = new PaginationController($scope, $http, $rootScope, Upload);
    $scope.controllerName = "TrademarksController";

    $scope.filter = {
        search: ''
    };

    $scope.items = [];
    $scope.item = null;
    $scope.isLoading = false;
    $scope.mode = 'create';
    $scope.isEditSlug = false;
    $scope.statuses = ['ACTIVE', 'PENDING'];
    $scope.types = ['trademark', 'violation', 'brand', 'warning'];
    $scope.claims = ['email', 'dmca', 'ticket', 'counterfeit', 'cloud', 'other'];
    $scope.filters = {};
    $scope.test = {
        name: '',
        tested: false,
        results: []
    }
    $scope.trademarkProductCount;

    $scope.initialize = function () {
        $scope.find();
    }

    $scope.find = function (refresh = false) {
        if (refresh) {
            $scope.meta.page_id = 0;
        }
        let url = '/trademarks?&sorts=-id';


        url = $scope.buildPaginationUrl(url, 20);
        url = $scope.buildUrl(url);

        url = $scope.buildFilterUrl(url, ['keyword'])
        if ($scope.filters.keyword) {
            if(url.includes('filters=')) {
                url += ',keyword~' + $scope.filters.keyword;
            } else {
                url += '&filters=keyword~' + $scope.filters.keyword;
            }
        }
        $scope.isLoading = true;
        $http.get(url)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.items = response.data.result;
                    $scope.checkHasProduct($scope.items);
                    $scope.getTrademarkProductCount($scope.items);
                    $scope.meta = response.data.meta;
                }
                $scope.isLoading = false;
            }, function (error) {
                $scope.isLoading = false;
            })
    }

    $scope.checkHasProduct = function (items) {
        $http.get('/trademarks/has-violate-product?ids=' + items.map(item => item.id).join(','))
            .then(function (response) {
                let result = response.data.result;
                for (let id in result) {
                    if (!result[id]) {
                        for (let key in $scope.items) {
                            if ($scope.items[key].id == id) {
                                $scope.items[key].not_has_violate_product = true;
                                break;
                            }
                        }
                    }
                }
            })
    }

    $scope.getTrademarkProductCount = (items) => 
    {
        const trademarkIds = [];
        for (let i = 0; i < items.length; i++) {
            trademarkIds.push(items[i].id);
        }

        let url = '/service/get-trademark-product-count?trademark_ids=' + trademarkIds.join(',');
            url = $scope.buildUrl(url);
        
        $http.get(url).then((response) => {
            $scope.trademarkProductCount = response.data;
        });
    }

    $scope.next = function () {
        if ($scope.increasePageId()) {
            $scope.find();
        }
    };

    $scope.prev = function () {
        if ($scope.decreasePageId()) {
            $scope.find();
        }
    };

    $scope.changePage = function (page) {
        if ($scope.changePageId(page)) {
            $scope.find();
        }
    };

    $scope.newItem = function () {
        $scope.mode = 'create';
        $scope.item = {
            type: 'trademark',
            status: 'ACTIVE'
        };

        $('#tag-modal').modal('toggle');
    }

    $scope.edit = function (item) {
        $scope.mode = 'update';
        $scope.item = angular.copy(item);

        $('#tag-modal').modal('toggle');
    }

    $scope.onChangeTitle = function () {
        if (!$scope.isEditSlug && (!$scope.item.id || !$scope.item.slug)) {
            $scope.item.slug = $scope.toFriendlyString($scope.item.title);
        }
    }

    $scope.onChangeSlug = function () {
        $scope.isEditSlug = true;
    }

    $scope.save = function () {
        if (!$scope.item.keyword) {
            toastr.error('Vui lòng nhập từ khóa');
            return;
        }
        if ($scope.item.type == 'trademark' && !$scope.item.link && !$scope.item.image_url) {
            toastr.error('Vui lòng nhập link hoặc hình ảnh dẫn chứng');
            return;
        }
        // if ($scope.item.link && !validURL($scope.item.link)) {
        //     toastr.error('Vui lòng nhập link dẫn chứng đúng định dạng');
        //     return;
        // }
        $scope.isLoading = true;
        let url = '/trademarks/store';
        let method = 'POST';
        if ($scope.item.id) {
            url = '/trademarks/update/' + $scope.item.id;
            method = 'PATCH';
        }
        let data = {
            keyword: $scope.item.keyword,
            link: $scope.item.link,
            image_url: $scope.item.image_url,
            status: $scope.item.status,
            type: $scope.item.type,
            claim: $scope.item.claim,
        }

        $http({
            url: url,
            method: method,
            data: data
        }).then(function (response) {
            if (response.data.status == 'successful') {
                $scope.find();
                $('#tag-modal').modal('toggle');
                toastr.success(($scope.item.id ? 'Sửa' : 'Thêm') + ' trademarks thành công!');
            } else {
                toastr.error(response.data.message);
            }
            $scope.isLoading = false;
        }, function (error) {
            if (error.data && error.data.includes('Duplicate entry') && error.data.includes("for key 'keyword'")) {
                toastr.error('Keyword đã tồn tại, vui lòng thử lại');
            } else {
                toastr.error('Có lỗi xảy ra, vui lòng thử lại');
            }

            $scope.isLoading = false;
        })
    }

    $scope.onChangeStatus = function (item) {
        $scope.isLoading = true;
        $http({
            url: '/trademarks/change-status/' + item.id,
            method: 'PATCH',
            data: {status: item.status}
        }).then(function (response) {
            if (response.data.status == 'successful') {
                toastr.success('Đổi status thành công!');
            } else {
                toastr.error('Có lỗi xảy ra, vui lòng thử lại');
            }
            $scope.isLoading = false;
        }, function (error) {
            toastr.error('Có lỗi xảy ra, vui lòng thử lại');

            $scope.isLoading = false;
        })
    }

    $scope.uploadImage = async function (file) {
        if (file && file['type']) {
            const validImageTypes = ['image/jpeg', 'image/png'];
            if (validImageTypes.includes(file['type'])) {
                var image = await $scope.upload(file, 'trademarks');
                if (image) {
                    $scope.$applyAsync(function () {
                        $scope.item.image_url = image;
                    });
                }
            } else {
                toastr.error('Vui lòng upload file ảnh');
            }
        }
    }

    $scope.upload = function (file, type = 'default', callback) {
        if (typeof file == 'array') {
            file = file[0];
        }
        return new Promise(function (resolve, reject) {
            Upload.upload({
                url: googleCloudStorageBucket + '/upload',
                data: {upload: file, type: type}
            }).then(function (resp) {
                if (resp.data.status == 'successful') {
                    let upload = resp.data.upload[0];
                    resolve(upload);
                } else {
                    reject(0);
                }
            }, function (resp) {
                reject(0);
            }, function (evt) {
                let progressPercentage = parseInt(100.0 * evt.loaded / evt.total);
                $scope.progressPercentage = progressPercentage;
            });
        });

    };

    function validURL(str) {
        var pattern = new RegExp('^(https?:\\/\\/)?' + // protocol
            '((([a-z\\d]([a-z\\d-]*[a-z\\d])*)\\.)+[a-z]{2,}|' + // domain name
            '((\\d{1,3}\\.){3}\\d{1,3}))' + // OR ip (v4) address
            '(\\:\\d+)?(\\/[-a-z\\d%_.~+]*)*' + // port and path
            '(\\?[;&a-z\\d%_.~+=-]*)?' + // query string
            '(\\#[-a-z\\d_]*)?$', 'i'); // fragment locator
        return !!pattern.test(str);
    }

    $scope.delete = function (item) {
        if (confirm('Bạn chắc chắn muốn xóa trademarks: ' + item.keyword + '?')) {
            $http.delete('/trademarks/' + item.id)
                .then(function (response) {
                    if (response.data.status == 'successful') {
                        $scope.find();
                        toastr.success('Xóa trademarks thành công!');
                    }
                })
        }
    }

    $scope.checkTrademarkAll = function () {
        if (confirm('Bạn chắc chắn muốn check vi phạm thương hiệu tất cả sản phẩm?')) {
            $scope.isCheckingAll = true;
            $http.get('/trademarks/check-all').then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.isCheckingAll = false;
                    toastr.success('Check vi phạm thương hiệu tất cả sản phẩm thành công');
                } else if (response.data.status == 'processing') {
                    toastr.error('Check vi phạm thương hiệu tất cả sản phẩm do tiến trình đang được chạy');
                } else {
                    toastr.error('Check vi phạm thương hiệu tất cả sản phẩm không thành công! Vui lòng thử lại');
                }
            });
        }
    }

    $scope.importItems = function (items) {
        $http.post('/trademarks/import', {
            items: items
        }).then(function (res) {
            if (res.data.status == 'successful') {
                window.location.reload();
            } else {
                toastr.error('Đã có lỗi xảy ra vui lòng liên hệ đội kỹ thuật');
            }
        }, function (error) {
            toastr.error('Đã có lỗi xảy ra vui lòng liên hệ đội kỹ thuật');
        })
    }

    $scope.loadFile = async function (files) {
        if (files && files.length) {
            $scope.file = files[0];
            var reader = new FileReader();
            let fileExt = getFileExtension($scope.file.name);
            if (fileExt == 'csv') {
                reader.readAsText($scope.file);
            } else if (fileExt == 'xls' || fileExt == 'xlsx') {
                reader.readAsBinaryString($scope.file);
            }
            reader.onload = await function (e) {
                var content = e.target.result;
                var items = processData(content, fileExt);
                $scope.importItems(items);
            };
            toastr.warning('Dữ liệu đang được import. Vui lòng chờ trong giây lát');
        }
    }

    function processData(content, fileExt) {
        let objects = [];
        try {
            if (fileExt == 'csv') {
                objects = $.csv.toObjects(content);
            } else if (fileExt == 'xls' || fileExt == 'xlsx') {
                let workbook = XLSX.read(content, {
                    type: 'binary'
                });
                workbook.SheetNames.forEach(sheet => {
                    let arrayObject = XLSX.utils.sheet_to_row_object_array(
                        workbook.Sheets[sheet]
                    );
                    objects = objects.concat(arrayObject);
                });
            }
        } catch (ex) {
            console.log(ex);
            $scope.showErrorModal('Không thể đọc được file.');
        }

        return objects;
    }

    function getFileExtension(filename) {
        var ext = /^.+\.([^.]+)$/.exec(filename);
        return ext == null ? "" : ext[1];
    }

    $scope.hideProduct = (trademark) => {
        $http.patch(baseApiUrl + '/trademarks/' + trademark.id, {
            "is_hide_product": !trademark.is_hide_product
        })
            .then(function (response) {
                if (response.data.status == 'successful') {
                    trademark.is_hide_product = response.data.result.is_hide_product;
                    toastr.success('Cập nhật thành công!');
                }
            }).catch(err => {
            toastr.error('Lỗi! Liên hệ với đội kỹ thuật');
        })
    }

    $scope.openTestModal = function () {
        $scope.test = {
            name: '',
            tested: false,
            results: []
        }
        $('#test-modal').modal('toggle');
    }

    $scope.testName = function () {
        $scope.test.results = [];
        $scope.test.tested = false;

        $http.get('/trademarks/test-trademark?value=' + $scope.test.name)
            .then(function (response) {
                if (response.data.status == 'successful') {
                    for (let key of Object.keys(response.data.result)) {
                        for (let item of response.data.result[key]) {
                            $scope.test.results.push(item.keyword);
                        }
                    }
                }
                $scope.test.tested = true;
            })
    }

    $scope.initialize();

}
