<!DOCTYPE html>
<html lang="en" dir="ltr">
<head>
    <meta charset="utf-8">
    <title>{{ __('DMCA takedown notice') }} - {{ config('app.name') }}</title>
</head>
<?php 
$baseUrl = URL::to('/'); 
$siteName = config('ticket::sa.site_name', 'Printerval');
$email = config('ticket::sa.send_email.email', 'support@printerval.com');
$emailLegal = config('ticket::sa.send_email.email_legal', 'legal@printeval.com');
$cdnUrl = config('ticket::sa.cdn_url', 'https://cdn.printerval.com/unsafe');
$logoEmail = config('ticket::sa.logo_email', 'https://cdn.printerval.com/unsafe/120x0/printerval.com/images/logo-email.png');
$parse = parse_url($baseUrl);
$host = 'www.' . $parse['host'];
?>
<body style="background: #ffffff; font-family: Arial, Helvetica, sans-serif;">
    <table style="width: 100%; max-width: 800px; border: 0; text-align: center; border-collapse: collapse; line-height: 1.5;">
        <tr style="padding: 0; border: none; vertical-align: center; text-align: center">
            <td style="padding: 0; border: none; font-family: Arial, Helvetica, sans-serif; font-size: 15px; text-align: center">
                <table style="width: 90%; margin: 0 auto; border: 0; text-align: center; border-collapse: collapse">
                    <tr style="padding: 0; border: none">
                        <td style="padding: 0; border: none; font-family: Arial, Helvetica, sans-serif; font-size: 15px">
                            <div style="width: 100%; border-top: 12px solid #ff6600; border-radius: 12px 12px 0 0; padding: 8px 0; text-align: justify;  line-height: 1.5;">
                                <p>Dear {{ $user['name'] }}</p>
                                <p>{{ $siteName }} has taken down the product:</p>
                                <table style="width: 100%; margin: 20px 0">
                                    <tbody>
                                        <tr>
                                            <th style="width: 300px">SKU</th>
                                            <th>Product Name</th>
                                        </tr>
                                        @foreach ($products as $item)
                                            @php
                                                $item = (array) $item;
                                            @endphp
                                            <tr>
                                                <td>
                                                    {{ $item['sku'] }}
                                                </td>
                                                <td>{{ $item['name'] }}</td>
                                            </tr>
                                        @endforeach
                                    </tbody>
                                </table>
                                <p>We received a report with information showing that this is an infringement product.</p>
                                <p>Please provide us with proof of ownership of this product and we will review all the information before taking action accordingly.</p>
                                <p>If you can’t provide us with proof of ownership of this product within five business days, your account will be listed on the flagged accounts.</p>
                                <p>For further information about DMCA and Intellectual Property Policy, please check this link: <a href="{{ $baseUrl }}/dmca-n12.html">{{ $baseUrl }}/dmca-n12.html</a>
                                If you need help with adjusting the statement or have any questions/concerns, contact our Legal team at <a href="mailTo:{{ $emailLegal }}">{{ $emailLegal }}</a>.</p>
                                <p>Thank you in advance and have a good day.</p>
                                <p style="font-family: Arial, Helvetica, sans-serif; font-size: 15px; color: #555; text-align: justify"><strong>{{ $siteName }} Legal Team</strong></p>
                            </div>
                        </td>
                    </tr>
                </table>
            </td>
        </tr>
    </table>
</body>
</html>