@extends('system.layout.main', [
    'ngController' => 'HideProductByLinkController'
])

@section('title')
    <title>Ẩn sản phẩm</title>
@endsection

@section('css')
    <style>
        .chosen-container-multi {
            width: 100% !important;
            margin-bottom: 10px;
        }
        .chosen-container-multi .chosen-choices li.search-field input[type=text] {
            height: 30px !important;
        }
    </style>
@endsection

@section('script')
    <script>
        var baseFileManagerUrl = '<?=config('sa.file_manager_url')?>';
        var baseApiUrl = '{{ config("sa.api_url") }}';
        $('#filter > button').on('click', function(event) {
            $(this).parent().toggleClass('open');
        });
        $('body').on('click', function(e) {
            if (!$('#filter').is(e.target) &&
                $('#filter').has(e.target).length === 0 &&
                $('.open').has(e.target).length === 0
            ) {
                $('#filter').removeClass('open');
            }
        });
        $('.dropdown-toggle').dropdown();

        const userLogin = <?=  json_encode(\Illuminate\Support\Facades\Auth::user()); ?>;
        let locals = <?=  json_encode(getModuleLocale()); ?>;
        locals = locals.filter(local => local.enable).map((local) => {
            return {
                code: local.locale,
                name: local.name,
            };
        });

        var restQUrl = "{{ config('restq.origin') }}";

    </script>
    <script src="/system/js/scripts/angular-inview.min.js?v={{ config('sa.version') }}" charset="utf-8"></script>
    <script src="/modules/trademarks/controllers/hide-product-by-link-controller.js?v={{ config('sa.version') }}" charset="utf-8"></script>
@endsection

@section('content')
    <div class="content">
        <div class="row">
            <div class="col-md-12" style="margin: 15px 0px">
                <div class="pull-left">
                    <h3 style="margin: 0">
                        Ẩn sản phẩm bằng link
                    </h3>
                </div>
            </div>
            <div class="col-md-12" style="min-height: 500px">
                <div class="box no-border">
                    <div class="box-body">
                        <div class="form-group">
                            <span class="text-danger" style="margin-bottom: 10px;">(*) Mỗi link một dòng</span>
                            <textarea class="form-control" placeholder="Danh sách links"
                                      rows="10"
                                      ng-model="productLinks" style="resize: vertical"
                                      on-change="inputOnChange()"
                            ></textarea>
                        </div>
                        <div style="margin: 10px 0px;">
                            <span class="text-danger">Danh sách ID:</span>
                            <span>
                                @{{ productIds  }}
                            </span>
                        </div>
                        <div class="row">
                            <div class="col-md-4">
                                <p><strong>Chọn từ khoá vi phạm:</strong></p>
                                <select chosen multiple ng-options="item.id as item.keyword for item in trademarkItems" ng-model="config.selectedTrademarkItems"></select>
                            </div>
                            <div class="col-md-4">
                                <p><strong>Chọn lí do vi phạm:</strong></p>
                                <select class="form-control" ng-options="item.value as item.title for item in reasons" ng-model="config.selectedReason">
                                    <option value="">-- Chọn lí do vi phạm --</option>
                                </select>
                            </div>
                            <div class="col-md-4">
                                <p><strong>Tuỳ chọn:</strong></p>
                                <span>
                                    <input style="margin-right: 10px" type="checkbox" id="is_hide_same_design" ng-model="config.isHideSameDesign" ng-checked="config.isHideSameDesign == true" />
                                    <label for="is_hide_same_design">ẩn sp cùng design</label>
                                </span>
                            </div>
                        </div>
                        <div>
                            <p><strong>Note:</strong></p>   
                            <textarea class="form-control" ng-model="config.note" rows="5"></textarea>
                        </div>
                        <div class="mt-3">
                            <button class="btn btn-danger" ng-disabled="isLoading" ng-click="hideProducts()">Ẩn sản phẩm</button>
                            <button class="btn btn-danger ml-5" ng-disabled="isLoading" ng-click="hideProductsDelay()">Ẩn sản phẩm sau 5 tiếng</button>
                            <button class="btn btn-warning ml-5" ng-disabled="isLoading" ng-click="markViolation()">Tích vi phạm quảng cáo</button>
                        </div>
                        <h4 ng-if="productBySellers.length">Sp của seller</h4>
                        <table class="table table-responsive mt-5" ng-if="productBySellers.length">
                            <tr>
                                <th>STT</th>
                                <th>Seller</th>
                                <th>Email</th>
                                <th>Sản phẩm</th>
                            </tr>
                            <tr ng-repeat="item in productBySellers">
                                <td>@{{ $index + 1 }}</td>
                                <td>@{{ item.user.name }}</td>
                                <td>@{{ item.user.email }}</td>
                                <td>
                                    <p ng-repeat="product in item.products">
                                        @{{ buildProductUrl(product) }}
                                    </p>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection