@extends('system.layout.main', [
    'ngController' => 'ImpactKeywordController'
])
@section('title')
    <title>Sự ảnh hưởng của một từ khóa</title>
@endsection
@section('css')
   
@endsection
@section('script')
    <script>
        const baseApiUrl = '{{ config("sa.api_url") }}';
    </script>
    <script src="/system/js/scripts/jquery-csv.min.js"></script>
    <script src="/system/js/scripts/xlsx.full.min.js"></script>
    <script src="/system/js/controllers/pagination/pagination-controller.js?v=<?= config("sa.version") ?>" charset="utf-8"></script>
    <script src="<?= Module::asset('trademarks/controllers/impact-keyword-controller.js') ?>?v={{ config('sa.version') }}" charset="utf-8"></script>
@endsection
@section('content')
    <div id="tag-list">
        <div class="content">
            <div class="row">
                <div class="col-md-12" style="margin: 15px 0px">
                    <div class="pull-left">
                        <h3 style="margin: 0">Tính ảnh hưởng của từ khóa</h3>
                    </div>
                </div>
                <div class="col-md-12">
                    <div class="box no-border">
                        <div class="col-md-10">
                            <div class="form-group">
                                <input ng-model="filter.keyword" type="text" class="form-control"
                                       placeholder="Điền từ khóa">
                            </div>
                        </div>
                        <div class="col-md-2">
                            <div class="input-btn">
                                <button type="button" class="btn btn-default " ng-click="check()">
                                    <i class="fa fa-search"></i>
                                    Tìm kiếm
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-md-12" style="min-height: 500px">
                    <div class="col-md-3 col-sm-6 col-xs-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-aqua"><i class="ion ion-ios-gear-outline"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Số S/P sẽ bị ẩn</span>
                                <span class="info-box-number">@{{loading ? 'Đang tính toán...' : result.count_hide_products}}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6 col-xs-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-aqua"><i class="ion ion-ios-gear-outline"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Số S/P sẽ bị ẩn quảng cáo</span>
                                <span class="info-box-number">@{{loading ? 'Đang tính toán...' : result.count_hide_feed_products }}</span>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-6 col-xs-12">
                        <div class="info-box">
                            <span class="info-box-icon bg-green"><i class="ion ion-ios-cart-outline"></i></span>
                            <div class="info-box-content">
                                <span class="info-box-text">Số đơn hàng</span>
                                <span class="info-box-number">@{{loading ? 'Đang tính toán...' : result.count_orders}}</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
