<script>
    system.controller("CheckTradeMarksController", CheckTradeMarksController);
    function CheckTradeMarksController($scope, $http, $rootScope) {
        $scope.isCheckingAll = false;
        $scope.showWarningTrademarks = function (product) {
            var retVal = [];
            var trademarksObj = product.trademarks;
            if (product.trademarks) {
                trademarksObj = JSON.parse(product.trademarks);
                for (var key in trademarksObj) {
                    if (trademarksObj[key].length > 0) {
                        retVal.push('- ' + $scope.upperCaseFirstLetter(key) + ': ' + trademarksObj[key].join(', '));
                    }
                }
            }
            return retVal.join('\n');
        }

        $scope.checkTrademark = function (product, index) {
            $('#btn-trademarks-' + product.id).button('loading');
            $http.get('/trademarks/check?id=' + product.id).then(function (response) {
                if (response.data.status == 'successful') {
                    $scope.products[index].trademarks = JSON.stringify(response.data.data);
                } else {
                    $scope.showErrorModal('Check! Vui lòng thử lại');
                }
                $('#btn-trademarks-' + product.id).button('reset');
            });
        }

        $scope.checkTrademarkAll = function () {
            if (confirm('Bạn chắc chắn muốn check vi phạm thương hiệu tất cả sản phẩm?')) {
                $scope.isCheckingAll = true;
                $http.get('/trademarks/check-all').then(function (response) {
                    if (response.data.status == 'successful') {
                        $scope.isCheckingAll = false;
                        $scope.showSuccessModal('Check vi phạm thương hiệu tất cả sản phẩm');
                    } else if (response.data.status == 'processing') {
                        $scope.showErrorModal('Check vi phạm thương hiệu tất cả sản phẩm do tiến trình đang được chạy');
                    } else {
                        $scope.showErrorModal('Check vi phạm thương hiệu tất cả sản phẩm! Vui lòng thử lại');
                    }
                });
                $scope.showNotifyModal('Check vi phạm thương hiệu tất cả sản phẩm đang được thực hiện, quá trình có thể mất nhiều thời gian, vui lòng chờ hoặc thực hiện công việc khác');
            }
        }

        $scope.checkIsTrademarks = function (product) {
            var retVal = false;
            var trademarks = product.trademarks;
            if (trademarks) {
                var trademarksObj = JSON.parse(trademarks);
                for (var key in trademarksObj) {
                    if (trademarksObj[key] && trademarksObj[key].length > 0) {
                        retVal = true;
                        break;
                    }
                }
            }
            return retVal;
        }
        // $scope.checkingAll = function () {
        //     $http.get('/trademarks/checking-all').then(function (response) {
        //         if (response.data.status == 'successful') {
        //             if (response.data.data) {
        //                 $scope.isCheckingAll = true;
        //             } else {
        //                 $scope.isCheckingAll = false;
        //             }
        //         }
        //     });
        // }
        // $scope.checkingAll();

        // setInterval(function () {
        //     $scope.checkingAll();
        // }, 10000)

    }
</script>
