@extends('system.layout.main', [
'ngController' => 'TrademarkProductSellerController'
])
@section('title')
    <title>Sản phẩm seller vi phạm</title>
@endsection
@section('css')
    <style media="screen">
        .tag-item {
            cursor: pointer;
        }

        .tag-item .view-tag {
            display: none;
        }

        .tag-item:hover .view-tag {
            display: block;
        }

        .form-radio {
            width: 15px;
            height: 15px;
        }
    </style>
    <style media="screen">
        .tag-title {
            margin-top: 4px;
            font-size: 1.6rem;
            -webkit-line-clamp: 1;
            -webkit-box-orient: vertical;
            overflow: hidden;
            text-overflow: ellipsis;
            display: -webkit-box;
            word-break: break-word;
            width: 70%;
        }

        @media only screen

        (
        max-width:

        768
        px

        )
        {
        .tag-title {
            width: 60%;
        }

        }

        .d-flex {
            display: flex;
        }

        .checkbox {
            margin: 0 10px !important;
        }
    </style>
    <style>
        .fixed .wrapper {
            overflow: visible;
            /* padding-top: 53px; */
        }

        /* .content-wrapper {
            position: relative;
            padding-top: 0 !important;
        } */

        .content .tag-form-header {
            position: -webkit-sticky;
            position: sticky;
            top: 50px;
            background-color: #ecf0f5;
            z-index: 100;
        }

        span.warning {
            display: block;
            background-color: orange;
            color: white;
            padding: 5px;
        }

        .bulk-actions-inner-bar li {
            padding: 10px 5px;
        }

        .chosen-container {
            width: 100% !important;
        }

        .chosen-container-single .chosen-single {
            height: 33px !important;
            line-height: 33px !important;
        }
    </style>
@endsection
@section('script')
    <script>
        const baseApiUrl = '{{ config("sa.api_url") }}';
        var staffs = <?= isset($staffs) && !empty($staffs) ? json_encode($staffs): null ?>;
        var sellers = <?= isset($sellers) && !empty($sellers) ? json_encode($sellers): null ?>;
    </script>
    <script src="/system/js/scripts/jquery-csv.min.js"></script>
    <script src="/system/js/scripts/xlsx.full.min.js"></script>
    <script src="/system/js/controllers/pagination/pagination-controller.js?v=<?= config("sa.version") ?>" charset="utf-8"></script>
    <script src="<?= Module::asset('trademarks/controllers/trademark-product-seller-controller.js') ?>?v={{ config('sa.version') }}" charset="utf-8"></script>
@endsection
@section('content')
    <div id="tag-list">
        <div class="content">
            <div class="row">
                <div class="col-md-12" style="margin: 15px 0px">
                    <div class="pull-left">
                        <h3 style="margin: 0">Sản phẩm seller vi phạm</h3>
                    </div>
                    <div class="pull-right">
                        <button class="btn btn-default" ng-click="export()"><i class="fa fa-upload"></i> Xuất</button>
                    </div>
                </div>
                <div class="col-md-12" style="min-height: 500px">
                    <div class="box no-border">
                        <div class="nav-tabs-custom">

                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            @include('trademarks::trademark-product-seller.filter')
                            @include('trademarks::trademark-product-seller.list')
                            <div class="pull-right">
                                @include('system.pagination')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
