@extends('system.layout.main', [
'ngController' => 'TrademarksSellerController'
])
@section('title')
    <title>Trademarks Seller</title>
@endsection
@section('css')
    <style media="screen">
        .tag-item {
            cursor: pointer;
        }

        .tag-item .view-tag {
            display: none;
        }

        .tag-item:hover .view-tag {
            display: block;
        }

        .form-radio {
            width: 15px;
            height: 15px;
        }
    </style>
    <style media="screen">
        .tag-title {
            margin-top: 4px;
            font-size: 1.6rem;
            -webkit-line-clamp: 1;
            -webkit-box-orient: vertical;
            overflow: hidden;
            text-overflow: ellipsis;
            display: -webkit-box;
            word-break: break-word;
            width: 70%;
        }
        @media only screen (max-width: 768px) {
            .tag-title {
                width: 60%;
            }
        }

        .d-flex {
            display: flex;
        }

        .checkbox {
            margin: 0 10px !important;
        }
    </style>
    <style>
        .fixed .wrapper {
            overflow: visible;
            /* padding-top: 53px; */
        }

        /* .content-wrapper {
            position: relative;
            padding-top: 0 !important;
        } */

        .content .tag-form-header {
            position: -webkit-sticky;
            position: sticky;
            top: 50px;
            background-color: #ecf0f5;
            z-index: 100;
        }

        span.warning {
            display: block;
            background-color: orange;
            color: white;
            padding: 5px;
        }
    </style>
@endsection
@section('script')
    <script>
        const baseApiUrl = '{{ config("sa.api_url") }}';
    </script>
    <script src="/system/js/scripts/jquery-csv.min.js"></script>
    <script src="/system/js/scripts/xlsx.full.min.js"></script>
    <script src="/system/js/controllers/pagination/pagination-controller.js?v=<?= config("sa.version") ?>" charset="utf-8"></script>
    <script src="<?= Module::asset('trademarks/js/trademarks-seller-controller.js') ?>?v={{ config('sa.version') }}" charset="utf-8"></script>
    <script src="<?= Module::asset('trademarks/js/import-violation-product-controller.js') ?>?v={{ config('sa.version') }}" charset="utf-8"></script>
@endsection
@section('content')
    <div id="tag-list">
        <div class="content">
            <div class="row">
                <div class="col-md-12" style="margin: 15px 0px">
                    <div class="pull-left">
                        <h3 style="margin: 0">Danh sách Trademarks Seller</h3>
                    </div>
                    <div class="pull-right">
{{--                        <button data-toggle="modal" data-target="#import-modal" class="btn btn-warning" role="button">--}}
{{--                            <i class="fa fa-download"></i> Nhập sp vi phạm--}}
{{--                        </button>--}}
                        <a href="{{ route('trademarks-seller::export') }}" target="_blank" class="btn btn-default" role="button">
                            <i class="fa fa-upload"></i> Xuất
                        </a>
                        <button ngf-select="loadFile($files)" class="btn btn-default" role="button">
                            <i class="fa fa-download"></i> Nhập
                        </button>
                        @view('trademarks::btn-check-all')
                        <button class="btn btn-primary" type="button" ng-click="openTestModal()">
                            Test keyword
                        </button>
                        <button class="btn btn-success" type="button" ng-click="newItem()">
                            <i class="fa fa-plus"></i> Thêm mới
                        </button>
                    </div>
                </div>
                <div class="col-md-12" style="min-height: 500px">
                    <div class="box no-border">
                        <div class="nav-tabs-custom">

                        </div>
                        <!-- /.box-header -->
                        <div class="box-body">
                            @include('trademarks::trademark-seller.filter')
                            @include('trademarks::trademark-seller.list')
                            <div class="pull-right" ng-if="items.length > 0">
                                @include('system.pagination')
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('trademarks::trademark-seller.modal')
    @include('trademarks::trademark-seller.test-modal')
    @include('trademarks::trademark-seller.import-modal')
@endsection
