@extends('system.layout.main', [])
@section('title')
<title>Từ khóa vi phạm</title>
@endsection
@section('content')

@section('script')
<script>
    var baseApiUrl = '{{ config("sa.api_url") }}';
</script>
<script src="/system/js/scripts/jquery-csv.min.js?v={{ config('app.version') }}"></script>
<script src="/system/js/scripts/xlsx.full.min.js?v={{ config('app.version') }}"></script>
<script src="/system/js/controllers/pagination/pagination-controller.js?v={{ config('app.version') }}" charset="utf-8"></script>
<script src="@asset('trademarks/controllers/ads-violation-keywords-controller.js')?v={{ config('app.version') }}" charset="utf-8">
</script>
@endsection

<div class="content" ng-controller="AdsViolationKeywords" ng-cloak>
    <div class="header" ng-show="mode == 'list'">
        <div class="pull-left">
            <h3 class="">Danh sách từ khóa vi phạm</h3>
        </div>
        <button type="button" name="button" class="btn btn-success btn-flat pull-right add"
            ng-click="create();mode = 'create'">Thêm feed</button>
        <div class="clearfix">
        </div>
    </div>
    <div class="body">
        <div class="box no-border">
            <div class="box-body">
                <div class="row">
{{--                    <div class="col-md-12 pull-right text-right mb-4">--}}
{{--                        <a href="{{ route('trademarks::export-violation') }}" target="_blank" class="btn btn-default"><i class="fa fa-upload"></i> Xuất</a>--}}

{{--                        <button ngf-select="loadFile($files)" href="{{ route('trademarks::export') }}" class="btn btn-default ml-3" role="button">--}}
{{--                            <i class="fa fa-download"></i> Nhập--}}
{{--                        </button>--}}
{{--                    </div>--}}
                </div>
                <div class="input-group">
                    <!-- /btn-group -->
                    <input ng-model="keyword" type="text" class="form-control"
                        ng-keyUp="$event.keyCode === 13 && searchFilter()" placeholder="Tìm kiếm keyword">
                    <div class="input-group-btn">
                        <button type="button" class="btn btn-primary btn-flat" ng-click="searchFilter()">
                            <i class="fa fa-search"></i>
                            Tìm kiếm
                        </button>
                    </div>
                </div>
                <div class="table-responsive">
                    <table class="table table-hover">
                        <br>
                        <tbody>
                            <tr>
                                <td style="padding: 8px 0px;">
                                    <input type="text" class="form-control designer-off-time" ng-model="newKeyword" placeholder="Thêm keyword">
                                </td>
                                <td style="padding: 8px 0px;">
                                    <button class="btn btn-success" ng-click="addKeyword()">Add</button>
                                </td>
                            </tr>
                            <tr>
                                <th width="100%">Keyword</th>
                                <th>#</th>
                            </tr>
                            <tr ng-repeat="item in data track by $index" ng-show="data.length > 0">
                                <td>@{{ item.keyword }}</td>
                                <td>
                                    <button class="btn btn-danger" ng-click="removeKeyword(item)">
                                    <i class="fa fa-trash"></i>
                                    </button>
                                </td>
                            </tr>
                            <tr ng-show="data.length == 0">
                                <td colspan="4" class="text-center">Không có keywords nào</td>
                            </tr>

                        </tbody>
                    </table>
                </div>
            </div>
            <!-- /.box-body -->
            <div class="box-footer clearfix">
            </div>
        </div>
    </div>
</div>

@endsection