
<div style="position: relative">
    <div class="bulk-actions" ng-show="selectedProductLength > 0">
        <div class="bulk-actions-inner">
            <ul class="bulk-actions-inner-bar">
                <li class="segments" style="background: #dfe3e8;font-weight: bold;padding: 10px 5px;">
                    <input id="js-reset-or-check-all" type="checkbox" ng-model="isSelectedAll" ng-checked="isSelectedAll == true" ng-change="resetOrCheckAll()">
                    <span>@{{ selectedProductLength }} sản phẩm được chọn</span>
                </li>
                <li class="segments dropdown" style="cursor: pointer; display: inline-block; width: auto">
                    <span class="dropdown-toggle" data-toggle="dropdown">
                        Chọn hành động <span class="caret"></span>
                    </span>
                    <ul class="dropdown-menu" style="left: -4px;clear: both;padding: 0;margin-top: 6px;">
                        <li class="actions" ng-click="markTrademark()">
                            <i class="fa fa-exclamation-triangle" aria-hidden="true"></i> Đánh dấu sp trademark
                        </li>

                        <li class="actions" ng-click="removeWarning()">
                            <i class="fa fa-trash" aria-hidden="true"></i> Bỏ cảnh báo
                        </li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
    <table class="table table-responsive">
        <thead>
            <th style="width: 50px">
                <input type="checkbox" id="js-product-checkall" ng-model="isSelectedAll" ng-checked="isSelectedAll == true" ng-change="resetOrCheckAll()">
            </th>
            <th style="width: 100px">Ảnh</th>
            <th>Sản phẩm</th>
            <th style="width: 200px">Từ khóa</th>
            <th style="width: 150px"></th>
            <th style="width: 150px"></th>
            <th style="width: 200px"></th>
        </thead>
        <tbody> 
            <tr ng-repeat="item in products" ng-if="products.length > 0 && !loading">
                <td>
                    <input type="checkbox" class="js-product-checkbox" ng-model="item.selected" ng-checked="item.selected == true" ng-click="addSelectedProducts($index)">
                </td>
                <td>
                    <div class="sb-product-thumbnail" ng-if="item.image_url">
                        <img referrerpolicy="no-referrer" ng-src="@{{ getImageCdn(item.image_url, 540, 540) }}" alt="" class="adminImageSearch">
                    </div>
                </td>
                <td>
                    <p>
                        <a target="_blank" href="@{{ item.url }}">@{{ item.name }}</a>
                    </p>
                    <p>
                        <span>(Tạo - @{{ summarizeDateTime(item.created_at, true) }})</span>
                    </p>
                    <p>
                        <span ng-if="item.actor">
                            <img referrerpolicy="no-referrer" src="/system/images/profile.png" alt="" width="16px">
                            <span>@{{ item.actor.name }}</span>
                        </span>
                        <span class="text-danger" ng-if="item.updated_at != item.created_at">(Cập nhật - @{{ summarizeDateTime(item.updated_at, true) }})</span>
                    </p>
                    <p>ID: @{{ item.product_id }}</p>
                </td>
                <td>
                    <p>@{{ item.trademark.keyword }}</p>
                    <p>ID: @{{ item.trademark_id }}</p>
                </td>
                <td>
                    <p>Sold: @{{ item.sold }}</p>
                    <p>View: @{{ item.view_count }}</p>
                </td>
                <td>
                    <p ng-if="item.approve_advertising">Đã duyệt qc</p>
                    <p ng-if="item.fed">Đã lên feed</p>
                    <div ng-if="item.performance">
                        <p>Click: @{{ item.performace.click }}</p>
                        <p>Impression: @{{ item.performace.impression }}</p>
                    </div>
                </td>
                <td>
                    <a href="@{{ buildSiteUrl('/admin/products/' + item.product_id) }}" target="_blank" type="button" class="btn btn-primary" title="Sửa">
                        <i class="fa fa-pencil" aria-hidden="true"></i>
                    </a>

                    <button type="button" class="btn btn-warning ml-4" title="Đánh dấu trademark" ng-click="markTrademark(item)">
                        <i class="fa fa-exclamation-triangle" aria-hidden="true"></i>
                    </button>

                    <button type="button" class="btn btn-danger ml-4" title="Bỏ cảnh báo" ng-click="removeWarning(item)">
                        <i class="fa fa-trash" aria-hidden="true"></i>
                    </button>
                </td>
            </tr>
            <tr ng-if="loading">
                <td colspan="5">Đang lọc sản phẩm</td>
            </tr>
            <tr ng-if="products.length == 0 && !loading">
                <td colspan="5">Không có sp nào</td>
            </tr>
        </tbody>
    </table>
</div>

