<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
 */
$systemAuth = config('app.system_auth_middleware');
Route::group(['prefix' => 'trademarks', 'middleware' => 'example'], function () use ($systemAuth) {
    Route::delete('/{id}', 'HomeController@deleteTrademark');
    Route::patch('/change-status/{id}', 'Services\TrademarkController@changeStatus');
    Route::post('/store', 'Services\TrademarkController@store');
    Route::patch('/update/{id}', 'Services\TrademarkController@update');


    Route::get('/check', [
        'as' => 'trademarks::home',
        'uses' => 'HomeController@check',
    ]);

    Route::get('check-violation', ['uses' => 'ViolationController@checkViolation']);
    Route::post('check-violation', ['uses' => 'ViolationController@checkViolation']);

    Route::get('recheck-violation', ['uses' => 'HomeController@recheckProductIsViolate']);
    Route::post('recheck-violation', ['uses' => 'HomeController@recheckProductIsViolate']);

    Route::get('check-design-violation', ['uses' => 'DesignTrademarkController@checkViolation']);
    Route::post('check-design-violation', ['uses' => 'DesignTrademarkController@checkViolation']);

    Route::any('rebuild-keyword-replacement', ['uses' => 'KeywordReplacementController@rebuild']);

    Route::get('/check-all', [
        'as' => 'trademarks::check-all',
        'uses' => 'HomeController@checkAll',
    ]);
    Route::post('/check-all', [
        'as' => 'trademarks::check-all',
        'uses' => 'HomeController@checkAll',
    ]);
    Route::post('/check-all-by-design', 'CheckByDesignController@checkAll');
    
    Route::get('/checking-all', [
        'as' => 'trademarks::checking-all',
        'uses' => 'HomeController@checkingAll',
    ]);
    Route::get('/check-tag', [
        'as' => 'trademarks::check-tag',
        'uses' => 'HomeController@checkTag',
    ]);

    Route::post('/update-is-trademark', 'HideProductController@updateIsTradmark');

    Route::get('/management', [
        'as' => 'trademarks::management',
        'uses' => 'HomeController@management'
    ])->middleware($systemAuth);
    
    Route::get('/keyword-replacement', [
        'as' => 'trademarks::keyword-replacement',
        'uses' => 'KeywordReplacementController@index'
    ])->middleware($systemAuth);

    Route::get('/export', 'ImportController@export')->name('trademarks::export')->middleware($systemAuth);
    Route::post('/import', 'ImportController@import')->name('trademarks::import')->middleware($systemAuth);

    Route::get('/export-violation', 'ImportController@exportViolationKeyword')
        ->name('trademarks::export-violation')->middleware($systemAuth);
    Route::post('/import-violation', 'ImportController@importViolationKeyword')
        ->name('trademarks::import-violation')->middleware($systemAuth);

    Route::post('/import-violation-product', 'ImportViolationProductController@import')->name('trademarks::import-violation')->middleware($systemAuth);
    Route::post('/set-violation-product', 'ImportViolationProductController@setViolationProduct')->name('trademarks::set-violation');

    Route::get('/export-keyword-replacement', 'ImportController@exportKeywordReplacement')
        ->name('trademarks::export-keyword-replacement')->middleware($systemAuth);
    Route::post('/import-keyword-replacement', 'ImportController@importKeywordReplacement')
        ->name('trademarks::import-keyword-replacement')->middleware($systemAuth);

    Route::get('/violation-keywords', 'HomeController@violationKeywords')->name('trademarks::violation-keywords');

    Route::get('/sync/trademark-keywords', 'HomeController@syncKeywordTrademarkToOtherLocation');

    Route::get('/hide-product-by-link', 'HideProductController@index')->name('trademarks::hide-by-link');
    Route::post('/hide-product-by-ids', 'HideProductController@hideProductByIds');
    Route::post('/mark-violation-product-by-ids', 'HideProductController@markViolationProductByIds');

    Route::get('test-trademark', 'HomeController@testTrademark');
    Route::post('test-trademark', 'HomeController@testTrademark');
    Route::get('has-violate-product', 'HomeController@hasVioloateProduct');

    Route::group(['prefix' => 'warning-product'], function () use ($systemAuth) {
        Route::get('/', 'WarningProductController@index')->name('trademarks::warning-product');
        Route::get('/find', 'WarningProductController@find');
        Route::post('/hide-warning', 'WarningProductController@hideWarning');
    });
    Route::group(['prefix' => 'wrong-language'], function () use ($systemAuth) {
        Route::get('/', 'WrongLanguageController@index')->name('trademarks::wrong-language');
        Route::get('/find', 'WrongLanguageController@find');
        Route::post('/hide-warning', 'WrongLanguageController@hideWarning');
    });

    Route::group(['prefix' => 'trademark-product'], function () use ($systemAuth) {
        Route::get('/', 'TrademarkProductController@index')->name('trademarks::trademark-product');
        Route::get('/find', 'TrademarkProductController@find');
        Route::post('/hide-warning', 'TrademarkProductController@hideWarning');
        Route::post('/export', 'TrademarkProductController@export')->middleware($systemAuth);
    });
    Route::get('/build-warning-order', 'WarningOrderController@buildWarning');

    Route::get('/check-by-search-service', 'CheckBySearchServiceController@check');

    Route::post('/sync-original-keyword', 'SyncOriginalProductController@sync');
    Route::post('/product-with-keyword', 'SyncOriginalProductController@productWithKeywords');
    Route::get('/impact-keyword', 'ImpactKeywordController@index')->name('trademarks::impact-keyword');
    Route::get('/impact-keyword/check', 'ImpactKeywordController@checkKeyword')->name('trademarks::impact-check-keyword');
});

//trademarks seller
Route::group(['prefix' => 'trademarks-seller', 'middleware' => 'example'], function () use ($systemAuth) {
    Route::delete('/{id}', 'Services\TrademarkSellerController@deleteTrademark');
    Route::patch('/change-status/{id}', 'Services\TrademarkSellerController@changeStatus');
    Route::post('/store', 'Services\TrademarkSellerController@store');
    Route::patch('/update/{id}', 'Services\TrademarkSellerController@update');

    Route::get('/management', [
        'as' => 'trademarks-seller::management',
        'uses' => 'TrademarkSellerController@management'
    ])->middleware($systemAuth);

    Route::any('test-trademark', 'TrademarkSellerController@testTrademark');
    Route::get('/export', 'ImportController@exportSeller')->name('trademarks-seller::export')->middleware($systemAuth);
    Route::post('/import', 'ImportController@importSeller')->name('trademarks-seller::import')->middleware($systemAuth);

    Route::get('/check-all', [
        'as' => 'trademarks-seller::check-all',
        'uses' => 'TrademarkSellerController@checkAll',
    ]);
    Route::get('/check-by-search-service', 'TrademarkSellerController@checkBySearchService');

    Route::group(['prefix' => 'trademark-product'], function () use ($systemAuth) {
        Route::get('/', 'TrademarkProductSellerController@index')->name('trademarks-seller::trademark-product');
        Route::get('/find', 'TrademarkProductSellerController@find');
        Route::post('/export', 'TrademarkProductSellerController@export')->middleware($systemAuth);
    });
});

Route::group(['prefix' => 'word', 'middleware' => 'example'], function () use ($systemAuth) {
    Route::get('/check-product-name', 'WordController@checkProductName');

});