<?php
Module::onView('title', function ($data) {
    return $data['page'] . ': This is title from Trademarks Module';
}, 10);
Module::onView('header', function ($data) {
    return view('trademarks::includes.header', [
        'moduleHeader' => getModuleOption('option.header'),
    ]);
}, 10);
Module::onView('content', function ($data) {
    return 'This is content view from Trademarks Module';
});

Module::onView("trademarks::btn", function() {
    return view('trademarks::btn');
}, 5);
Module::onView("trademarks::btn-check-all", function() {
    return view('trademarks::btn-check-all');
}, 5);
Module::onView("trademarks::script", function() {
    return view('trademarks::script');
}, 5);
Module::onView('trademarks::controller', function ($data) {
    return 'ng-controller="CheckTradeMarksController"';
});
Module::onView('system.menu', function () {
    return view('trademarks::menu');
});

Module::onView('trademark::check-trademark', function ($data) {
    return view('trademarks::includes.check-trademark', $data);
});

Module::onAction('hideProduct', 'Modules\Trademarks\EventListeners\HideProductListener@listen');
Module::onAction('productIsViolation', 'Modules\Trademarks\EventListeners\ViolationProductListener@listen');
Module::onAction('bulkHideProduct', 'Modules\Trademarks\EventListeners\BulkHideProductListener@listen');
Module::onAction('bulkProductIsViolation', 'Modules\Trademarks\EventListeners\BulkViolationProductListener@listen');
Module::onAction('hideProductByIds', 'Modules\Trademarks\EventListeners\HideProductByIdsListener@listen');