<?php

namespace Modules\WarehousePod\Controllers;

use Illuminate\Http\Request;
use Modules\WarehousePod\Controllers\Controller;
use Modules\Ticket\Helpers\DBconnect;
use Module;
use Modules\WarehousePod\Models\Category;
use Modules\WarehousePod\Models\Printing;
use Modules\WarehousePod\Models\ProductVariantOption;
use Modules\WarehousePod\Models\Warehouse;

class ProductPrintConfigController extends Controller
{
    protected $connection = null;

    public function __construct()
    {        
        parent::__construct();
        if ($this->connection == null) {
            $this->connection = DBconnect::connect($this->market);
        }
    }

    public function index(Request $request)
    {
        $printings = Printing::on($this->configName)
                                ->pluck('name', 'id')
                                ->toArray();
        $styles = ProductVariantOption::on($this->configName)
                                ->join("product_variant", "product_variant.id", "=", "product_variant_option.variant_id")
                                ->where("product_variant.slug", "style")
                                ->get(["product_variant_option.*"]);
        $categories = Category::on($this->configName)
                                ->where('type', '=', 'PRODUCT')
                                ->where('is_hidden', '=', 0)
                                ->orderBy('name', 'ASC')
                                ->pluck('name', 'id')
                                ->toArray();
        $options = $this->connection->table('product_variant')
                                    ->get(['name', 'id']);
        $styleById = [];
        foreach ($styles as $key => $value) {
            $styleById[$value->id] = $value;
        }
        return view('warehouse-pod::system.product-print.index', [
            'printings' => $printings,
            "categories" => $categories,
            "styles" => $styleById,
            "options" => $options
        ]);
    }
}
